/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.network.grouppriority;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;
import org.opentripplanner.routing.api.request.request.filter.TransitGroupSelect;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.network.grouppriority.EntityAdapter;
import org.opentripplanner.transit.model.network.grouppriority.Matcher;
import org.opentripplanner.transit.model.network.grouppriority.Matchers;
import org.opentripplanner.transit.model.network.grouppriority.TransitGroupPriority32n;
import org.opentripplanner.transit.model.network.grouppriority.TripAdapter;
import org.opentripplanner.transit.model.network.grouppriority.TripPatternAdapter;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.utils.lang.ArrayUtils;

public class TransitGroupPriorityService {
    private static final int GROUP_INDEX_COUNTER_START = 1;
    private final int baseGroupId = TransitGroupPriority32n.groupId(1);
    private int groupIndexCounter = 1;
    private final boolean enabled;
    private final Matcher[] agencyMatchers;
    private final Matcher[] globalMatchers;
    private final List<MatcherAgencyAndIds> agencyMatchersIds;
    private final List<MatcherAndId> globalMatchersIds;

    private TransitGroupPriorityService() {
        this.enabled = false;
        this.agencyMatchers = null;
        this.globalMatchers = null;
        this.agencyMatchersIds = List.of();
        this.globalMatchersIds = List.of();
    }

    public TransitGroupPriorityService(Collection<TransitGroupSelect> byAgency, Collection<TransitGroupSelect> global) {
        this.agencyMatchers = Matchers.of(byAgency);
        this.globalMatchers = Matchers.of(global);
        this.enabled = Stream.of(this.agencyMatchers, this.globalMatchers).anyMatch(ArrayUtils::hasContent);
        this.globalMatchersIds = Arrays.stream(this.globalMatchers).map(m -> new MatcherAndId((Matcher)m, this.nextGroupId())).toList();
        this.agencyMatchersIds = Arrays.stream(this.agencyMatchers).map(MatcherAgencyAndIds::new).toList();
    }

    public static TransitGroupPriorityService empty() {
        return new TransitGroupPriorityService();
    }

    public static TransitGroupPriorityService of(CostLinearFunction relaxTransitGroupPriority, List<TransitGroupSelect> groupByAgency, List<TransitGroupSelect> groupGlobal) {
        if (relaxTransitGroupPriority.isNormal()) {
            return TransitGroupPriorityService.empty();
        }
        if (Stream.of(groupByAgency, groupGlobal).allMatch(Collection::isEmpty)) {
            return TransitGroupPriorityService.empty();
        }
        return new TransitGroupPriorityService(groupByAgency, groupGlobal);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int lookupTransitGroupPriorityId(TripPattern tripPattern) {
        return tripPattern == null ? this.baseGroupId : this.lookupTransitGroupPriorityId(new TripPatternAdapter(tripPattern));
    }

    public int lookupTransitGroupPriorityId(Trip trip) {
        return trip == null ? this.baseGroupId : this.lookupTransitGroupPriorityId(new TripAdapter(trip));
    }

    private int lookupTransitGroupPriorityId(EntityAdapter entity) {
        if (!this.enabled) {
            return this.baseGroupId;
        }
        for (MatcherAgencyAndIds matcherAgencyAndIds : this.agencyMatchersIds) {
            if (!matcherAgencyAndIds.matcher().match(entity)) continue;
            FeedScopedId agencyId = entity.agencyId();
            int groupId = matcherAgencyAndIds.ids().get((Object)agencyId);
            if (groupId < 0) {
                groupId = this.nextGroupId();
                matcherAgencyAndIds.ids.put((Object)agencyId, groupId);
            }
            return groupId;
        }
        for (MatcherAndId matcherAndId : this.globalMatchersIds) {
            if (!matcherAndId.matcher.match(entity)) continue;
            return matcherAndId.groupId();
        }
        return this.baseGroupId;
    }

    public int baseGroupId() {
        return this.baseGroupId;
    }

    private int nextGroupId() {
        return TransitGroupPriority32n.groupId(++this.groupIndexCounter);
    }

    private record MatcherAgencyAndIds(Matcher matcher, TObjectIntMap<FeedScopedId> ids) {
        MatcherAgencyAndIds(Matcher matcher) {
            this(matcher, (TObjectIntMap<FeedScopedId>)new TObjectIntHashMap(10, 0.5f, -1));
        }
    }

    private record MatcherAndId(Matcher matcher, int groupId) {
    }
}

