/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.network.grouppriority;

class TransitGroupPriority32n {
    private static final int GROUP_ZERO = 0;
    private static final int MIN_SEQ_NO = 0;
    private static final int MAX_SEQ_NO = 32;

    TransitGroupPriority32n() {
    }

    static boolean dominate(int left, int right) {
        return ((left ^ right) & right) != 0;
    }

    static int groupId(int priorityGroupIndex) {
        TransitGroupPriority32n.assertValidGroupSeqNo(priorityGroupIndex);
        return priorityGroupIndex == 0 ? 0 : 1 << priorityGroupIndex - 1;
    }

    static int mergeInGroupId(int currentSetOfGroupIds, int newGroupId) {
        return currentSetOfGroupIds | newGroupId;
    }

    public String toString() {
        return "TransitGroupPriority32n{}";
    }

    private static void assertValidGroupSeqNo(int priorityGroupIndex) {
        if (priorityGroupIndex < 0) {
            throw new IllegalArgumentException("Transit group priority can not be a negative number: " + priorityGroupIndex);
        }
        if (priorityGroupIndex > 32) {
            throw new IllegalArgumentException("Transit group priority exceeds max number of groups: " + priorityGroupIndex + " (MAX=32)");
        }
    }
}

