/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.network.grouppriority;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opentripplanner.routing.api.request.request.filter.TransitGroupSelect;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.grouppriority.BinarySetOperator;
import org.opentripplanner.transit.model.network.grouppriority.EntityAdapter;
import org.opentripplanner.transit.model.network.grouppriority.Matcher;

final class Matchers {
    private static final Matcher NOOP = new EmptyMatcher();

    Matchers() {
    }

    static Matcher of(TransitGroupSelect select) {
        if (select.isEmpty()) {
            return NOOP;
        }
        ArrayList<Matcher> list = new ArrayList<Matcher>();
        if (!select.modes().isEmpty()) {
            list.add(new ModeMatcher(select.modes()));
        }
        if (!select.subModeRegexp().isEmpty()) {
            list.add(new RegExpMatcher("SubMode", select.subModeRegexp(), EntityAdapter::subMode));
        }
        if (!select.agencyIds().isEmpty()) {
            list.add(new IdMatcher("Agency", select.agencyIds(), EntityAdapter::agencyId));
        }
        if (!select.routeIds().isEmpty()) {
            list.add(new IdMatcher("Route", select.routeIds(), EntityAdapter::routeId));
        }
        return Matchers.andOf(list);
    }

    static Matcher[] of(Collection<TransitGroupSelect> selectors) {
        return (Matcher[])selectors.stream().map(Matchers::of).filter(Predicate.not(Matcher::isEmpty)).toArray(Matcher[]::new);
    }

    private static <T> String arrayToString(BinarySetOperator op, T[] values) {
        return Matchers.colToString(op, Arrays.asList(values));
    }

    private static <T> String colToString(BinarySetOperator op, Collection<T> values) {
        return values.stream().map(Objects::toString).collect(Collectors.joining(" " + String.valueOf((Object)op) + " "));
    }

    private static Matcher andOf(List<Matcher> list) {
        if ((list = list.stream().filter(Predicate.not(Matcher::isEmpty)).toList()).isEmpty()) {
            return NOOP;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return new AndMatcher(list);
    }

    private static final class ModeMatcher
    implements Matcher {
        private final Set<TransitMode> modes;

        public ModeMatcher(List<TransitMode> modes) {
            this.modes = EnumSet.copyOf(modes);
        }

        @Override
        public boolean match(EntityAdapter entity) {
            return this.modes.contains(entity.mode());
        }

        public String toString() {
            return "Mode(" + Matchers.colToString(BinarySetOperator.OR, this.modes) + ")";
        }
    }

    private static final class RegExpMatcher
    implements Matcher {
        private final String typeName;
        private final Pattern[] patterns;
        private final Function<EntityAdapter, String> toValue;

        public RegExpMatcher(String typeName, List<String> regexps, Function<EntityAdapter, String> toValue) {
            this.typeName = typeName;
            this.patterns = (Pattern[])regexps.stream().map(Pattern::compile).toArray(Pattern[]::new);
            this.toValue = toValue;
        }

        @Override
        public boolean match(EntityAdapter entity) {
            String value = this.toValue.apply(entity);
            for (Pattern p : this.patterns) {
                if (!p.matcher(value).matches()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.typeName + "Regexp(" + Matchers.arrayToString(BinarySetOperator.OR, this.patterns) + ")";
        }
    }

    private static final class IdMatcher
    implements Matcher {
        private final String typeName;
        private final Set<FeedScopedId> ids;
        private final Function<EntityAdapter, FeedScopedId> idProvider;

        public IdMatcher(String typeName, List<FeedScopedId> ids, Function<EntityAdapter, FeedScopedId> idProvider) {
            this.typeName = typeName;
            this.ids = new HashSet<FeedScopedId>(ids);
            this.idProvider = idProvider;
        }

        @Override
        public boolean match(EntityAdapter entity) {
            return this.ids.contains(this.idProvider.apply(entity));
        }

        public String toString() {
            return this.typeName + "Id(" + Matchers.colToString(BinarySetOperator.OR, this.ids) + ")";
        }
    }

    private static final class AndMatcher
    implements Matcher {
        private final Matcher[] matchers;

        public AndMatcher(List<Matcher> matchers) {
            this.matchers = (Matcher[])matchers.toArray(Matcher[]::new);
        }

        @Override
        public boolean match(EntityAdapter entity) {
            for (Matcher m : this.matchers) {
                if (m.match(entity)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "(" + Matchers.arrayToString(BinarySetOperator.AND, this.matchers) + ")";
        }
    }

    private static final class EmptyMatcher
    implements Matcher {
        private EmptyMatcher() {
        }

        @Override
        public boolean match(EntityAdapter entity) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public String toString() {
            return "Empty";
        }
    }
}

