/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.CompactLineStringUtils;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableBuilder;
import org.opentripplanner.routing.algorithm.raptoradapter.api.SlackProvider;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractEntityBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Direction;

public final class TripPatternBuilder
extends AbstractEntityBuilder<TripPattern, TripPatternBuilder> {
    private Route route;
    private TransitMode mode;
    private SubMode netexSubMode;
    private boolean containsMultipleModes;
    private StopPattern stopPattern;
    private Timetable scheduledTimetable;
    private TimetableBuilder scheduledTimetableBuilder;
    private String name;
    private boolean createdByRealtimeUpdate;
    private TripPattern originalTripPattern;
    private List<LineString> hopGeometries;

    TripPatternBuilder(FeedScopedId id) {
        super(id);
        this.scheduledTimetableBuilder = Timetable.of();
    }

    TripPatternBuilder(TripPattern original) {
        super(original);
        this.name = original.getName();
        this.route = original.getRoute();
        this.mode = original.getMode();
        this.netexSubMode = original.getNetexSubmode();
        this.containsMultipleModes = original.getContainsMultipleModes();
        this.stopPattern = original.getStopPattern();
        this.scheduledTimetable = original.getScheduledTimetable();
        this.createdByRealtimeUpdate = original.isCreatedByRealtimeUpdater();
        this.originalTripPattern = original.getOriginalTripPattern();
        this.hopGeometries = original.getGeometry() == null ? null : IntStream.range(0, original.numberOfStops() - 1).mapToObj(original::getHopGeometry).toList();
    }

    public TripPatternBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public TripPatternBuilder withRoute(Route route) {
        this.route = route;
        return this;
    }

    public TripPatternBuilder withMode(TransitMode mode) {
        this.mode = mode;
        return this;
    }

    public TripPatternBuilder withNetexSubmode(SubMode netexSubmode) {
        this.netexSubMode = netexSubmode;
        return this;
    }

    public TripPatternBuilder withContainsMultipleModes(boolean containsMultipleModes) {
        this.containsMultipleModes = containsMultipleModes;
        return this;
    }

    public TripPatternBuilder withStopPattern(StopPattern stopPattern) {
        this.stopPattern = stopPattern;
        return this;
    }

    public TripPatternBuilder withScheduledTimeTable(Timetable scheduledTimetable) {
        if (this.scheduledTimetableBuilder != null) {
            throw new IllegalStateException("Cannot set scheduled Timetable after scheduled Timetable builder is created");
        }
        this.scheduledTimetable = scheduledTimetable;
        return this;
    }

    public TripPatternBuilder withScheduledTimeTableBuilder(UnaryOperator<TimetableBuilder> producer) {
        if (this.scheduledTimetableBuilder == null) {
            this.scheduledTimetableBuilder = this.scheduledTimetable.copyOf();
            this.scheduledTimetable = null;
        }
        producer.apply(this.scheduledTimetableBuilder);
        return this;
    }

    public TripPatternBuilder withCreatedByRealtimeUpdater(boolean createdByRealtimeUpdate) {
        this.createdByRealtimeUpdate = createdByRealtimeUpdate;
        return this;
    }

    public TripPatternBuilder withOriginalTripPattern(TripPattern originalTripPattern) {
        this.originalTripPattern = originalTripPattern;
        return this;
    }

    public TripPatternBuilder withHopGeometries(List<LineString> hopGeometries) {
        this.hopGeometries = hopGeometries;
        return this;
    }

    public int slackIndex() {
        return SlackProvider.slackIndex(this.route.getMode());
    }

    public int transitReluctanceFactorIndex() {
        return this.route.getMode().ordinal();
    }

    public Direction getDirection() {
        if (this.scheduledTimetable != null) {
            return this.scheduledTimetable.getDirection();
        }
        return this.scheduledTimetableBuilder.getDirection();
    }

    @Override
    protected TripPattern buildFromValues() {
        return new TripPattern(this);
    }

    public Route getRoute() {
        return this.route;
    }

    public TransitMode getMode() {
        return this.mode != null ? this.mode : this.route.getMode();
    }

    public SubMode getNetexSubmode() {
        return this.netexSubMode != null ? this.netexSubMode : this.route.getNetexSubmode();
    }

    public boolean getContainsMultipleModes() {
        return this.containsMultipleModes;
    }

    public StopPattern getStopPattern() {
        return this.stopPattern;
    }

    public Timetable getScheduledTimetable() {
        return this.scheduledTimetable;
    }

    public TimetableBuilder getScheduledTimetableBuilder() {
        return this.scheduledTimetableBuilder;
    }

    public String getName() {
        return this.name;
    }

    public TripPattern getOriginalTripPattern() {
        return this.originalTripPattern;
    }

    public boolean isCreatedByRealtimeUpdate() {
        return this.createdByRealtimeUpdate;
    }

    public byte[][] hopGeometries() {
        List<LineString> geometries;
        if (this.hopGeometries != null) {
            geometries = this.hopGeometries;
        } else if (this.originalTripPattern != null) {
            geometries = this.generateHopGeometriesFromOriginalTripPattern();
        } else {
            return null;
        }
        return (byte[][])geometries.stream().map(hopGeometry -> CompactLineStringUtils.compactLineString(hopGeometry, false)).toArray(x$0 -> new byte[x$0][]);
    }

    private List<LineString> generateHopGeometriesFromOriginalTripPattern() {
        ArrayList<LineString> hopGeometries = new ArrayList<LineString>();
        for (int i = 0; i < this.stopPattern.getSize() - 1; ++i) {
            LineString hopGeometry;
            LineString lineString = hopGeometry = i < this.originalTripPattern.numberOfStops() - 1 ? this.originalTripPattern.getHopGeometry(i) : null;
            if (hopGeometry != null && this.stopPattern.sameStops(this.originalTripPattern.getStopPattern(), i)) {
                hopGeometries.add(this.originalTripPattern.getHopGeometry(i));
                continue;
            }
            if (hopGeometry != null && this.stopPattern.sameStations(this.originalTripPattern.getStopPattern(), i)) {
                Coordinate newStart = this.stopPattern.getStop(i).getCoordinate().asJtsCoordinate();
                Coordinate newEnd = this.stopPattern.getStop(i + 1).getCoordinate().asJtsCoordinate();
                Coordinate[] coordinates = (Coordinate[])this.originalTripPattern.getHopGeometry(i).getCoordinates().clone();
                coordinates[0].setCoordinate(newStart);
                coordinates[coordinates.length - 1].setCoordinate(newEnd);
                hopGeometries.add(GeometryUtils.getGeometryFactory().createLineString(coordinates));
                continue;
            }
            hopGeometries.add(GeometryUtils.getGeometryFactory().createLineString(new Coordinate[]{this.stopPattern.getStop(i).getCoordinate().asJtsCoordinate(), this.stopPattern.getStop(i + 1).getCoordinate().asJtsCoordinate()}));
        }
        return hopGeometries;
    }
}

