/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.network;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.utils.lang.MemEfficientArrayBuilder;

public final class StopPattern
implements Serializable {
    private final StopLocation[] stops;
    private final PickDrop[] pickups;
    private final PickDrop[] dropoffs;

    private StopPattern(int size) {
        this.stops = new StopLocation[size];
        this.pickups = new PickDrop[size];
        this.dropoffs = new PickDrop[size];
    }

    private StopPattern(StopLocation[] stops, PickDrop[] pickups, PickDrop[] dropoffs) {
        this.stops = stops;
        this.pickups = pickups;
        this.dropoffs = dropoffs;
    }

    public StopPattern(Collection<StopTime> stopTimes) {
        this(stopTimes.size());
        int size = stopTimes.size();
        if (size == 0) {
            return;
        }
        Iterator<StopTime> stopTimeIterator = stopTimes.iterator();
        for (int i = 0; i < size; ++i) {
            StopTime stopTime = stopTimeIterator.next();
            this.stops[i] = stopTime.getStop();
            this.pickups[i] = StopPattern.computePickDrop(stopTime.getStop(), stopTime.getPickupType());
            this.dropoffs[i] = StopPattern.computePickDrop(stopTime.getStop(), stopTime.getDropOffType());
        }
    }

    public static StopPatternBuilder create(int length) {
        return new StopPatternBuilder(new StopPattern(length), null);
    }

    StopPatternBuilder copyOf() {
        return new StopPatternBuilder(this, null);
    }

    StopPatternBuilder copyOf(StopPattern realTime) {
        return new StopPatternBuilder(this, realTime);
    }

    public int hashCode() {
        int hash = this.stops.length;
        hash += Arrays.hashCode(this.stops);
        hash *= 31;
        hash += Arrays.hashCode((Object[])this.pickups);
        hash *= 31;
        return hash += Arrays.hashCode((Object[])this.dropoffs);
    }

    public boolean equals(Object other) {
        if (other instanceof StopPattern) {
            StopPattern that = (StopPattern)other;
            return Arrays.equals(this.stops, that.stops) && Arrays.equals((Object[])this.pickups, (Object[])that.pickups) && Arrays.equals((Object[])this.dropoffs, (Object[])that.dropoffs);
        }
        return false;
    }

    public boolean stopsEqual(Object other) {
        if (other instanceof StopPattern) {
            StopPattern that = (StopPattern)other;
            return Arrays.equals(this.stops, that.stops);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StopPattern: ");
        int j = this.stops.length;
        for (int i = 0; i < j; ++i) {
            sb.append(String.format("%s_%s%s ", new Object[]{this.stops[i].getCode(), this.pickups[i], this.dropoffs[i]}));
        }
        return sb.toString();
    }

    public int getSize() {
        return this.stops.length;
    }

    public boolean isAllStopsNonRoutable() {
        return Arrays.stream(this.pickups).allMatch(PickDrop::isNotRoutable) && Arrays.stream(this.dropoffs).allMatch(PickDrop::isNotRoutable);
    }

    int findStopPosition(StopLocation stop) {
        for (int i = 0; i < this.stops.length; ++i) {
            if (this.stops[i] != stop) continue;
            return i;
        }
        return -1;
    }

    int findBoardingPosition(StopLocation stop) {
        return this.findStopPosition(0, this.stops.length - 1, s -> s == stop);
    }

    int findAlightPosition(StopLocation stop) {
        return this.findStopPosition(1, this.stops.length, s -> s == stop);
    }

    int findBoardingPosition(Station station) {
        return this.findStopPosition(0, this.stops.length - 1, station::includes);
    }

    int findAlightPosition(Station station) {
        return this.findStopPosition(1, this.stops.length, station::includes);
    }

    List<StopLocation> getStops() {
        return List.of(this.stops);
    }

    public StopLocation getStop(int stopPosInPattern) {
        return this.stops[stopPosInPattern];
    }

    PickDrop getPickup(int stopPosInPattern) {
        return this.pickups[stopPosInPattern];
    }

    PickDrop getDropoff(int stopPosInPattern) {
        return this.dropoffs[stopPosInPattern];
    }

    boolean canAlight(int stopPosInPattern) {
        return this.dropoffs[stopPosInPattern].isRoutable();
    }

    boolean canAlight(StopLocation stop) {
        for (int i = 0; i < this.stops.length - 1; ++i) {
            if (stop != this.stops[i] || !this.canAlight(i)) continue;
            return true;
        }
        return false;
    }

    boolean canBoard(int stopPosInPattern) {
        return this.pickups[stopPosInPattern].isRoutable();
    }

    boolean canBoard(StopLocation stop) {
        for (int i = 0; i < this.stops.length - 1; ++i) {
            if (stop != this.stops[i] || !this.canBoard(i)) continue;
            return true;
        }
        return false;
    }

    private static PickDrop computePickDrop(StopLocation stop, PickDrop pickDrop) {
        if (stop instanceof RegularStop) {
            return pickDrop;
        }
        return PickDrop.NONE;
    }

    private int findStopPosition(int start, int end, Predicate<StopLocation> match) {
        for (int i = start; i < end; ++i) {
            if (!match.test(this.stops[i])) continue;
            return i;
        }
        return -1;
    }

    boolean sameStops(StopPattern other, int index) {
        StopLocation otherOrigin = other.getStop(index);
        StopLocation otherDestination = other.getStop(index + 1);
        StopLocation origin = this.getStop(index);
        StopLocation destination = this.getStop(index + 1);
        return origin.equals(otherOrigin) && destination.equals(otherDestination);
    }

    boolean sameStations(StopPattern other, int index) {
        Station otherOrigin = other.getStop(index).getParentStation();
        Station otherDestination = other.getStop(index + 1).getParentStation();
        Station origin = this.getStop(index).getParentStation();
        Station destionation = this.getStop(index + 1).getParentStation();
        Boolean sameOrigin = Optional.ofNullable(origin).map(o -> o.equals(otherOrigin)).orElse(this.getStop(index).equals(other.getStop(index)));
        Boolean sameDestination = Optional.ofNullable(destionation).map(o -> o.equals(otherDestination)).orElse(this.getStop(index + 1).equals(other.getStop(index + 1)));
        return sameOrigin != false && sameDestination != false;
    }

    public static class StopPatternBuilder {
        public final MemEfficientArrayBuilder<StopLocation> stops;
        public final MemEfficientArrayBuilder<PickDrop> pickups;
        public final MemEfficientArrayBuilder<PickDrop> dropoffs;
        private final StopPattern original;
        @Nullable
        private final StopPattern realTime;

        public StopPatternBuilder(StopPattern original, StopPattern realTime) {
            this.stops = MemEfficientArrayBuilder.of((Object[])original.stops);
            this.pickups = MemEfficientArrayBuilder.of((Object[])original.pickups);
            this.dropoffs = MemEfficientArrayBuilder.of((Object[])original.dropoffs);
            this.original = original;
            this.realTime = realTime;
        }

        public StopPatternBuilder updatePickups(Map<Integer, PickDrop> updatedPickups) {
            for (Map.Entry<Integer, PickDrop> entry : updatedPickups.entrySet()) {
                this.pickups.with(entry.getKey().intValue(), (Object)entry.getValue());
            }
            return this;
        }

        public StopPatternBuilder updateDropoffs(Map<Integer, PickDrop> updatedDropoffs) {
            for (Map.Entry<Integer, PickDrop> entry : updatedDropoffs.entrySet()) {
                this.dropoffs.with(entry.getKey().intValue(), (Object)entry.getValue());
            }
            return this;
        }

        public StopPatternBuilder replaceStop(FeedScopedId old, StopLocation newStop) {
            Objects.requireNonNull(old);
            Objects.requireNonNull(newStop);
            for (int i = 0; i < this.stops.size(); ++i) {
                if (!((StopLocation)this.stops.getOrOriginal(i)).getId().equals(old)) continue;
                this.stops.with(i, (Object)newStop);
            }
            return this;
        }

        public StopPatternBuilder replaceStops(Map<Integer, StopLocation> newStops) {
            Objects.requireNonNull(newStops);
            for (Map.Entry<Integer, StopLocation> entry : newStops.entrySet()) {
                this.stops.with(entry.getKey().intValue(), (Object)entry.getValue());
            }
            return this;
        }

        public StopPattern build() {
            if (this.stops.isNotModified() && this.dropoffs.isNotModified() && this.pickups.isNotModified()) {
                return this.original;
            }
            if (this.realTime != null) {
                StopPattern newStopPattern = new StopPattern((StopLocation[])this.stops.build((Object[])this.realTime.stops), (PickDrop[])this.pickups.build((Object[])this.realTime.pickups), (PickDrop[])this.dropoffs.build((Object[])this.realTime.dropoffs));
                return this.realTime.equals(newStopPattern) ? this.realTime : newStopPattern;
            }
            return new StopPattern((StopLocation[])this.stops.build(), (PickDrop[])this.pickups.build(), (PickDrop[])this.dropoffs.build());
        }
    }
}

