/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.network;

import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.network.GroupOfRoutesBuilder;

public class GroupOfRoutes
extends AbstractTransitEntity<GroupOfRoutes, GroupOfRoutesBuilder>
implements LogInfo {
    private final String name;
    private final String privateCode;
    private final String shortName;
    private final String description;

    GroupOfRoutes(GroupOfRoutesBuilder builder) {
        super(builder.getId());
        this.name = builder.getName();
        this.privateCode = builder.getPrivateCode();
        this.shortName = builder.getShortName();
        this.description = builder.getDescription();
    }

    public static GroupOfRoutesBuilder of(FeedScopedId id) {
        return new GroupOfRoutesBuilder(id);
    }

    public String getName() {
        return this.logName();
    }

    @Override
    public String logName() {
        return this.name;
    }

    @Nullable
    public String getShortName() {
        return this.shortName;
    }

    @Nullable
    public String getPrivateCode() {
        return this.privateCode;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public GroupOfRoutesBuilder copy() {
        return new GroupOfRoutesBuilder(this);
    }

    @Override
    public boolean sameAs(GroupOfRoutes other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.name, other.name) && Objects.equals(this.shortName, other.shortName) && Objects.equals(this.privateCode, other.privateCode) && Objects.equals(this.description, other.description);
    }
}

