/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.framework;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.utils.lang.StringUtils;

public final class FeedScopedId
implements Serializable,
Comparable<FeedScopedId> {
    private static final char ID_SEPARATOR = ':';
    private final String feedId;
    private final String id;

    public FeedScopedId(String feedId, String id) {
        this.feedId = StringUtils.assertHasValue((String)feedId, (String)"Missing mandatory feedId on FeedScopeId", (Object[])new Object[0]);
        this.id = StringUtils.assertHasValue((String)id, (String)"Missing mandatory id on FeedScopeId", (Object[])new Object[0]);
    }

    @Nullable
    public static FeedScopedId ofNullable(String feedId, @Nullable String id) {
        return id == null || id.isBlank() ? null : new FeedScopedId(feedId, id);
    }

    @Nullable
    public static FeedScopedId parse(@Nullable String value) throws IllegalArgumentException {
        if (StringUtils.hasNoValue((String)value)) {
            return null;
        }
        int index = value.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException("invalid feed-scoped-id: " + value);
        }
        return new FeedScopedId(value.substring(0, index), value.substring(index + 1));
    }

    public static List<FeedScopedId> parse(Collection<String> value) throws IllegalArgumentException {
        value.forEach(id -> {
            if (id == null) {
                throw new IllegalArgumentException("Collection of FeedScopedId must not contain null.");
            }
        });
        return value.stream().map(FeedScopedId::parse).toList();
    }

    public static List<FeedScopedId> parseList(String s) {
        if (StringUtils.containsInvisibleCharacters((String)s)) {
            throw new IllegalArgumentException("The input string '%s' contains invisible characters which is not allowed.".formatted(s));
        }
        return Arrays.stream(s.split(",")).map(String::strip).filter(i -> !i.isBlank()).map(FeedScopedId::parse).toList();
    }

    public static boolean isValidString(@Nullable String value) throws IllegalArgumentException {
        return value != null && value.indexOf(58) > -1;
    }

    private static String concatenateId(String feedId, String id) {
        return feedId + ":" + id;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getId() {
        return this.id;
    }

    @Override
    @Deprecated
    public int compareTo(FeedScopedId o) {
        int c = this.feedId.compareTo(o.feedId);
        if (c == 0) {
            c = this.id.compareTo(o.id);
        }
        return c;
    }

    public int hashCode() {
        return this.feedId.hashCode() ^ this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeedScopedId)) {
            return false;
        }
        FeedScopedId other = (FeedScopedId)obj;
        return this.feedId.equals(other.feedId) && this.id.equals(other.id);
    }

    public String toString() {
        return FeedScopedId.concatenateId(this.feedId, this.id);
    }
}

