/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.framework;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.TransitEntity;

public class DefaultEntityById<E extends TransitEntity>
implements EntityById<E> {
    private final Map<FeedScopedId, E> map = new HashMap<FeedScopedId, E>();

    @Override
    public void add(E entity) {
        this.map.put(entity.getId(), entity);
    }

    @Override
    public void addAll(Collection<E> entities) {
        entities.forEach(this::add);
    }

    @Override
    public Collection<E> values() {
        return this.map.values();
    }

    @Override
    public E get(FeedScopedId id) {
        return (E)((TransitEntity)this.map.get(id));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(FeedScopedId id) {
        return this.map.containsKey(id);
    }

    @Override
    public Map<FeedScopedId, E> asImmutableMap() {
        return Map.copyOf(this.map);
    }

    @Override
    public int removeIf(Predicate<E> test) {
        return this.removeIf(test, null);
    }

    @Override
    public int removeIf(Predicate<E> test, Consumer<E> callback) {
        Collection<E> oldSet = this.map.values();
        Collection newSet = oldSet.stream().filter(Predicate.not(test)).collect(Collectors.toList());
        int size = this.map.size();
        if (newSet.size() == size) {
            return 0;
        }
        if (callback != null) {
            HashSet<E> removed = new HashSet<E>(oldSet);
            removed.removeAll(Set.copyOf(newSet));
            removed.forEach(callback);
        }
        this.map.clear();
        this.addAll(newSet);
        return size - this.map.size();
    }

    @Override
    public E computeIfAbsent(FeedScopedId id, Function<? super FeedScopedId, ? extends E> mappingFunction) {
        return (E)((TransitEntity)this.map.computeIfAbsent(id, mappingFunction));
    }

    public String toString() {
        return this.map.toString();
    }
}

