/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.framework;

import java.util.Objects;
import org.opentripplanner.transit.model.framework.AbstractBuilder;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.EntityContext;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.TransitEntityBuilder;

public abstract class AbstractEntityBuilder<E extends AbstractTransitEntity<E, B>, B extends AbstractEntityBuilder<E, B>>
extends AbstractBuilder<E, B>
implements TransitEntityBuilder<E, B> {
    private static final EntityContext<?, ?> NOOP = new EntityContext(){};
    private FeedScopedId id;
    private final EntityContext<E, B> context;

    public AbstractEntityBuilder(FeedScopedId id, EntityContext<E, B> context) {
        super(null);
        this.id = id;
        this.context = Objects.requireNonNull(context);
    }

    public AbstractEntityBuilder(FeedScopedId id) {
        this(id, (EntityContext<FeedScopedId, B>)AbstractEntityBuilder.noopContext());
    }

    public AbstractEntityBuilder(E original, EntityContext<E, B> context) {
        super(original);
        this.id = ((AbstractTransitEntity)original).getId();
        this.context = context;
    }

    public AbstractEntityBuilder(E original) {
        this(original, AbstractEntityBuilder.noopContext());
    }

    public final FeedScopedId getId() {
        return this.id;
    }

    public final B withId(FeedScopedId id) {
        this.id = id;
        return (B)this;
    }

    @Override
    public E save() {
        return this.context.save(this);
    }

    private static <E extends AbstractTransitEntity<E, B>, B extends AbstractEntityBuilder<E, B>> EntityContext<E, B> noopContext() {
        return NOOP;
    }
}

