/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.filter.transit;

import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.transit.api.request.TripTimeOnDateRequest;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.filter.expr.EqualityMatcher;
import org.opentripplanner.transit.model.filter.expr.ExpressionBuilder;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class TripTimeOnDateMatcherFactory {
    public static Matcher<TripTimeOnDate> of(TripTimeOnDateRequest request) {
        ExpressionBuilder expr = ExpressionBuilder.of();
        expr.atLeastOneMatch(request.includeAgencies(), TripTimeOnDateMatcherFactory::agencyId);
        expr.atLeastOneMatch(request.includeRoutes(), TripTimeOnDateMatcherFactory::routeId);
        expr.atLeastOneMatch(request.includeModes(), TripTimeOnDateMatcherFactory::mode);
        expr.matchesNone(request.excludeAgencies(), TripTimeOnDateMatcherFactory::agencyId);
        expr.matchesNone(request.excludeRoutes(), TripTimeOnDateMatcherFactory::routeId);
        expr.matchesNone(request.excludeModes(), TripTimeOnDateMatcherFactory::mode);
        return expr.build();
    }

    private static Matcher<TripTimeOnDate> agencyId(FeedScopedId id) {
        return new EqualityMatcher<TripTimeOnDate, FeedScopedId>("agency", id, t -> t.getTrip().getRoute().getAgency().getId());
    }

    private static Matcher<TripTimeOnDate> routeId(FeedScopedId id) {
        return new EqualityMatcher<TripTimeOnDate, FeedScopedId>("route", id, t -> t.getTrip().getRoute().getId());
    }

    private static Matcher<TripTimeOnDate> mode(TransitMode mode) {
        return new EqualityMatcher<TripTimeOnDate, TransitMode>("mode", mode, t -> t.getTrip().getRoute().getMode());
    }
}

