/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.filter.transit;

import java.time.LocalDate;
import org.opentripplanner.transit.api.request.TripOnServiceDateRequest;
import org.opentripplanner.transit.model.filter.expr.ContainsMatcher;
import org.opentripplanner.transit.model.filter.expr.EqualityMatcher;
import org.opentripplanner.transit.model.filter.expr.ExpressionBuilder;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.TripAlteration;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;

public class TripOnServiceDateMatcherFactory {
    public static Matcher<TripOnServiceDate> of(TripOnServiceDateRequest request) {
        ExpressionBuilder expr = ExpressionBuilder.of();
        expr.atLeastOneMatch(request.serviceDates(), TripOnServiceDateMatcherFactory::serviceDate);
        expr.atLeastOneMatch(request.agencies(), TripOnServiceDateMatcherFactory::agencyId);
        expr.atLeastOneMatch(request.routes(), TripOnServiceDateMatcherFactory::routeId);
        expr.atLeastOneMatch(request.serviceJourneys(), TripOnServiceDateMatcherFactory::serviceJourneyId);
        expr.atLeastOneMatch(request.replacementFor(), TripOnServiceDateMatcherFactory::replacementFor);
        expr.atLeastOneMatch(request.netexInternalPlanningCodes(), TripOnServiceDateMatcherFactory::netexInternalPlanningCode);
        expr.atLeastOneMatch(request.alterations(), TripOnServiceDateMatcherFactory::alteration);
        return expr.build();
    }

    static Matcher<TripOnServiceDate> agencyId(FeedScopedId id) {
        return new EqualityMatcher<TripOnServiceDate, FeedScopedId>("agency", id, t -> t.getTrip().getRoute().getAgency().getId());
    }

    static Matcher<TripOnServiceDate> routeId(FeedScopedId id) {
        return new EqualityMatcher<TripOnServiceDate, FeedScopedId>("route", id, t -> t.getTrip().getRoute().getId());
    }

    static Matcher<TripOnServiceDate> serviceJourneyId(FeedScopedId id) {
        return new EqualityMatcher<TripOnServiceDate, FeedScopedId>("serviceJourney", id, t -> t.getTrip().getId());
    }

    static Matcher<TripOnServiceDate> replacementFor(FeedScopedId id) {
        return new ContainsMatcher("replacementForContains", t -> t.getReplacementFor().stream().map(AbstractTransitEntity::getId).toList(), new EqualityMatcher<FeedScopedId, FeedScopedId>("replacementForIdEquals", id, idToMatch -> idToMatch));
    }

    static Matcher<TripOnServiceDate> netexInternalPlanningCode(String code) {
        return new EqualityMatcher<TripOnServiceDate, String>("netexInternalPlanningCode", code, t -> t.getTrip().getNetexInternalPlanningCode());
    }

    static Matcher<TripOnServiceDate> serviceDate(LocalDate date) {
        return new EqualityMatcher<TripOnServiceDate, LocalDate>("serviceDate", date, TripOnServiceDate::getServiceDate);
    }

    static Matcher<TripOnServiceDate> alteration(TripAlteration alteration) {
        return new EqualityMatcher<TripOnServiceDate, TripAlteration>("alteration", alteration, TripOnServiceDate::getTripAlteration);
    }
}

