/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.filter.transit;

import java.time.LocalDate;
import java.util.Set;
import java.util.function.Function;
import org.opentripplanner.transit.api.request.TripRequest;
import org.opentripplanner.transit.model.filter.expr.ContainsMatcher;
import org.opentripplanner.transit.model.filter.expr.EqualityMatcher;
import org.opentripplanner.transit.model.filter.expr.ExpressionBuilder;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.Trip;

public class TripMatcherFactory {
    public static Matcher<Trip> of(TripRequest request, Function<FeedScopedId, Set<LocalDate>> serviceDateProvider) {
        ExpressionBuilder<Trip> expr = ExpressionBuilder.of();
        expr.atLeastOneMatch(request.includeAgencies(), TripMatcherFactory::agencyId);
        expr.atLeastOneMatch(request.includeRoutes(), TripMatcherFactory::routeId);
        expr.matchesNone(request.excludeAgencies(), TripMatcherFactory::agencyId);
        expr.matchesNone(request.excludeRoutes(), TripMatcherFactory::routeId);
        expr.atLeastOneMatch(request.includeNetexInternalPlanningCodes(), TripMatcherFactory::netexInternalPlanningCode);
        expr.atLeastOneMatch(request.includeServiceDates(), TripMatcherFactory.serviceDate(serviceDateProvider));
        return expr.build();
    }

    static Matcher<Trip> agencyId(FeedScopedId id) {
        return new EqualityMatcher<Trip, FeedScopedId>("agency", id, t -> t.getRoute().getAgency().getId());
    }

    static Matcher<Trip> routeId(FeedScopedId id) {
        return new EqualityMatcher<Trip, FeedScopedId>("route", id, t -> t.getRoute().getId());
    }

    static Matcher<Trip> netexInternalPlanningCode(String code) {
        return new EqualityMatcher<Trip, String>("netexInternalPlanningCode", code, Trip::getNetexInternalPlanningCode);
    }

    static Function<LocalDate, Matcher<Trip>> serviceDate(Function<FeedScopedId, Set<LocalDate>> serviceDateProvider) {
        return date -> new ContainsMatcher("serviceDate", t -> (Iterable)serviceDateProvider.apply(t.getServiceId()), new EqualityMatcher<LocalDate, LocalDate>("serviceDate", (LocalDate)date, dateToMatch -> dateToMatch));
    }
}

