/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.filter.transit;

import java.util.function.Predicate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.api.request.FindRoutesRequest;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.filter.expr.CaseInsensitiveStringPrefixMatcher;
import org.opentripplanner.transit.model.filter.expr.EqualityMatcher;
import org.opentripplanner.transit.model.filter.expr.ExpressionBuilder;
import org.opentripplanner.transit.model.filter.expr.GenericUnaryMatcher;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.filter.expr.NullSafeWrapperMatcher;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;

public class RouteMatcherFactory {
    public static Matcher<Route> of(FindRoutesRequest request, Predicate<Route> isFlexRoutePredicate) {
        ExpressionBuilder<Route> expr = ExpressionBuilder.of();
        if (request.flexibleOnly()) {
            expr.matches(RouteMatcherFactory.isFlexRoute(isFlexRoutePredicate));
        }
        expr.atLeastOneMatch(request.agencies(), RouteMatcherFactory::agencies);
        expr.atLeastOneMatch(request.transitModes(), RouteMatcherFactory::transitModes);
        if (request.shortName() != null) {
            expr.matches(RouteMatcherFactory.shortName(request.shortName()));
        }
        expr.atLeastOneMatch(request.shortNames(), RouteMatcherFactory::shortNames);
        if (request.longName() != null) {
            expr.matches(RouteMatcherFactory.longName(request.longName()));
        }
        return expr.build();
    }

    static Matcher<Route> agencies(String agencyId) {
        return new NullSafeWrapperMatcher<Route, Agency>("agency", Route::getAgency, new EqualityMatcher<Route, String>("agencyId", agencyId, route -> route.getAgency().getId().getId()));
    }

    static Matcher<Route> transitModes(TransitMode transitMode) {
        return new EqualityMatcher<Route, TransitMode>("transitMode", transitMode, Route::getMode);
    }

    static Matcher<Route> shortName(String publicCode) {
        return new NullSafeWrapperMatcher<Route, String>("shortName", Route::getShortName, new EqualityMatcher<Route, String>("shortName", publicCode, Route::getShortName));
    }

    static Matcher<Route> shortNames(String publicCode) {
        return new NullSafeWrapperMatcher<Route, String>("shortNames", Route::getShortName, new EqualityMatcher<Route, String>("shortNames", publicCode, Route::getShortName));
    }

    static Matcher<Route> isFlexRoute(Predicate<Route> isFlexRoute) {
        return new GenericUnaryMatcher<Route>("isFlexRoute", isFlexRoute);
    }

    static Matcher<Route> longName(String name) {
        return new NullSafeWrapperMatcher<Route, I18NString>("longName", Route::getLongName, new CaseInsensitiveStringPrefixMatcher<Route>("name", name, route -> route.getLongName().toString()));
    }
}

