/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.filter.transit;

import java.util.function.Predicate;
import org.opentripplanner.transit.api.request.FindRegularStopsByBoundingBoxRequest;
import org.opentripplanner.transit.model.filter.expr.EqualityMatcher;
import org.opentripplanner.transit.model.filter.expr.ExpressionBuilder;
import org.opentripplanner.transit.model.filter.expr.GenericUnaryMatcher;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.site.RegularStop;

public class RegularStopMatcherFactory {
    public static Matcher<RegularStop> of(FindRegularStopsByBoundingBoxRequest request, Predicate<RegularStop> inUseProvider) {
        ExpressionBuilder<RegularStop> expr = ExpressionBuilder.of();
        if (request.feedId() != null) {
            expr.matches(RegularStopMatcherFactory.feedId(request.feedId()));
        }
        if (request.filterByInUse()) {
            expr.matches(RegularStopMatcherFactory.inUseMatcher(inUseProvider));
        }
        return expr.build();
    }

    static Matcher<RegularStop> feedId(String feedId) {
        return new EqualityMatcher<RegularStop, String>("feedId", feedId, stop -> stop.getId().getFeedId());
    }

    static Matcher<RegularStop> inUseMatcher(Predicate<RegularStop> inUseProvider) {
        return new GenericUnaryMatcher<RegularStop>("inUse", inUseProvider);
    }
}

