/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.filter.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opentripplanner.transit.model.filter.expr.BinaryOperator;
import org.opentripplanner.transit.model.filter.expr.Matcher;

public final class OrMatcher<T>
implements Matcher<T> {
    private final Matcher<T>[] matchers;

    private OrMatcher(List<Matcher<T>> matchers) {
        this.matchers = (Matcher[])matchers.toArray(Matcher[]::new);
    }

    public static <T> Matcher<T> of(Matcher<T> a, Matcher<T> b) {
        return OrMatcher.of(List.of(a, b));
    }

    public static <T> Matcher<T> of(List<Matcher<T>> matchers) {
        if (matchers.size() == 1) {
            return matchers.get(0);
        }
        ArrayList<Matcher<T>> expr = new ArrayList<Matcher<T>>();
        for (Matcher<T> it : matchers) {
            if (it instanceof OrMatcher) {
                OrMatcher orMatcher = (OrMatcher)it;
                expr.addAll(Arrays.asList(orMatcher.matchers));
                continue;
            }
            expr.add(it);
        }
        return new OrMatcher<T>(expr);
    }

    @Override
    public boolean match(T entity) {
        for (Matcher<T> m : this.matchers) {
            if (!m.match(entity)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "(" + BinaryOperator.OR.arrayToString(this.matchers) + ")";
    }
}

