/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.filter.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.opentripplanner.transit.api.model.FilterValues;
import org.opentripplanner.transit.model.filter.expr.AndMatcher;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.filter.expr.NegationMatcher;
import org.opentripplanner.transit.model.filter.expr.OrMatcher;

public class ExpressionBuilder<T> {
    private final List<Matcher<T>> matchers = new ArrayList<Matcher<T>>();

    public static <T> ExpressionBuilder<T> of() {
        return new ExpressionBuilder<T>();
    }

    public ExpressionBuilder<T> matches(Matcher<T> matcher) {
        this.matchers.add(matcher);
        return this;
    }

    public <V> ExpressionBuilder<T> atLeastOneMatch(FilterValues<V> filterValues, Function<V, Matcher<T>> matcherProvider) {
        if (filterValues.includeEverything()) {
            return this;
        }
        this.matchers.add(OrMatcher.of(filterValues.get().stream().map(matcherProvider).toList()));
        return this;
    }

    public <V> ExpressionBuilder<T> matchesNone(FilterValues<V> filterValues, Function<V, Matcher<T>> matcherProvider) {
        if (filterValues.includeEverything()) {
            return this;
        }
        this.matchers.add(new NegationMatcher<T>("matchesNone", OrMatcher.of(filterValues.get().stream().map(matcherProvider).toList())));
        return this;
    }

    public Matcher<T> build() {
        return AndMatcher.of(this.matchers);
    }
}

