/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.filter.expr;

import java.util.function.Function;
import org.opentripplanner.transit.model.filter.expr.Matcher;

public class EqualityMatcher<T, V>
implements Matcher<T> {
    private final String typeName;
    private final V value;
    private final Function<T, V> valueProvider;

    public EqualityMatcher(String typeName, V value, Function<T, V> valueProvider) {
        this.typeName = typeName;
        this.value = value;
        this.valueProvider = valueProvider;
    }

    @Override
    public boolean match(T entity) {
        return this.value.equals(this.valueProvider.apply(entity));
    }

    public String toString() {
        return this.typeName + "==" + String.valueOf(this.value);
    }
}

