/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.filter.expr;

import java.util.function.Function;
import org.opentripplanner.transit.model.filter.expr.Matcher;

public class ContainsMatcher<S, T>
implements Matcher<S> {
    private final String relationshipName;
    private final Function<S, Iterable<T>> valuesProvider;
    private final Matcher<T> valueMatcher;

    public ContainsMatcher(String relationshipName, Function<S, Iterable<T>> valuesProvider, Matcher<T> valueMatcher) {
        this.relationshipName = relationshipName;
        this.valuesProvider = valuesProvider;
        this.valueMatcher = valueMatcher;
    }

    @Override
    public boolean match(S entity) {
        if (this.valuesProvider.apply(entity) == null) {
            return false;
        }
        for (T it : this.valuesProvider.apply(entity)) {
            if (!this.valueMatcher.match(it)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ContainsMatcher: " + this.relationshipName + ": " + String.valueOf(this.valueMatcher);
    }
}

