/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.filter.expr;

import java.util.List;
import org.opentripplanner.transit.model.filter.expr.BinaryOperator;
import org.opentripplanner.transit.model.filter.expr.Matcher;

public final class AndMatcher<T>
implements Matcher<T> {
    private final Matcher<T>[] matchers;

    private AndMatcher(List<Matcher<T>> matchers) {
        this.matchers = (Matcher[])matchers.toArray(Matcher[]::new);
    }

    public static <T> Matcher<T> of(List<Matcher<T>> matchers) {
        if (matchers.size() == 1) {
            return matchers.get(0);
        }
        return new AndMatcher<T>(matchers);
    }

    @Override
    public boolean match(T entity) {
        for (Matcher<T> m : this.matchers) {
            if (m.match(entity)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "(" + BinaryOperator.AND.arrayToString(this.matchers) + ")";
    }
}

