/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.basic;

import java.util.EnumSet;
import java.util.Set;
import org.opentripplanner.framework.doc.DocumentedEnum;

public enum TransitMode implements DocumentedEnum<TransitMode>
{
    RAIL,
    COACH,
    SUBWAY,
    BUS,
    TRAM,
    FERRY,
    AIRPLANE,
    CABLE_CAR,
    GONDOLA,
    FUNICULAR,
    TROLLEYBUS,
    MONORAIL,
    CARPOOL,
    TAXI;

    private static final Set<TransitMode> ON_STREET_MODES;
    private static final Set<TransitMode> NO_AIRPLANE_MODES;
    private static final Set<TransitMode> NO_CARPOOL_MODES;

    public static Set<TransitMode> transitModesExceptAirplane() {
        return NO_AIRPLANE_MODES;
    }

    public static TransitMode[] modesConsideredTransitByUsers() {
        return (TransitMode[])NO_CARPOOL_MODES.toArray(TransitMode[]::new);
    }

    public boolean onStreet() {
        return ON_STREET_MODES.contains(this);
    }

    @Override
    public String typeDescription() {
        return "Routing modes for transit, including rail, bus, ferry, etc. Equivalent to [GTFS `route_type`](https://developers.google.com/transit/gtfs/reference/#routestxt) or to NeTEx TransportMode. ";
    }

    @Override
    public String enumValueDescription() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Used for intercity or long-distance travel.";
            case 1 -> "Used for long-distance bus routes.";
            case 2 -> "Subway or Metro, used for any underground rail system within a metropolitan area.";
            case 3 -> "Used for short- and long-distance bus routes.";
            case 4 -> "Tram, streetcar or light rail. Used for any light rail or street level system within a metropolitan area.";
            case 5 -> "Used for short- and long-distance boat service.";
            case 6 -> "Taking an airplane";
            case 7 -> "Used for street-level rail cars where the cable runs beneath the vehicle.";
            case 8 -> "Gondola or suspended cable car. Typically used for aerial cable cars where the car is suspended from the cable.";
            case 9 -> "Used for any rail system that moves on steep inclines with a cable traction system.";
            case 10 -> "Used for trolleybus systems which draw power from overhead wires using poles on the roof of the vehicle.";
            case 11 -> "Used for any rail system that runs on a single rail.";
            case 12 -> "Private car trips shared with others.\n\nThis is currently not specified in GTFS so we use the mode type values 1550-1560 which are in the range of private taxis.\n";
            case 13 -> "Using a taxi service";
        };
    }

    static {
        ON_STREET_MODES = EnumSet.of(COACH, BUS, TROLLEYBUS, CARPOOL, TAXI);
        NO_AIRPLANE_MODES = EnumSet.complementOf(EnumSet.of(AIRPLANE));
        NO_CARPOOL_MODES = EnumSet.complementOf(EnumSet.of(CARPOOL));
    }
}

