/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.basic;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record SubMode(String name, int index) implements Serializable
{
    private static final int NON_EXISTING_SUB_MODE_INDEX = 1000000;
    private static final Logger LOG = LoggerFactory.getLogger(SubMode.class);
    private static final Map<String, SubMode> ALL = new ConcurrentHashMap<String, SubMode>();
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    public static final SubMode UNKNOWN = SubMode.getOrBuildAndCacheForever("unknown");

    public static SubMode of(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        SubMode subMode = ALL.get(name);
        return subMode != null ? subMode : new SubMode(name, 1000000);
    }

    public static SubMode getOrBuildAndCacheForever(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        if (ALL.size() == 1000) {
            LOG.error("There are 1000 subModes in use, there might be a memory leak.");
        }
        return ALL.computeIfAbsent(name, it -> new SubMode((String)it, COUNTER.getAndIncrement()));
    }

    public static Set<SubMode> getByIndex(BitSet subModes) {
        HashSet<SubMode> set = new HashSet<SubMode>();
        for (SubMode value : ALL.values()) {
            if (!subModes.get(value.index())) continue;
            set.add(value);
        }
        return set;
    }

    public static List<SubMode> listAllCachedSubModes() {
        return List.copyOf(ALL.values());
    }

    public static void deserializeSubModeCache(Collection<SubMode> subModes) {
        int maxIndex = 0;
        for (SubMode it : subModes) {
            ALL.put(it.name(), it);
            maxIndex = Math.max(maxIndex, it.index);
        }
        COUNTER.set(maxIndex + 1);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubMode other = (SubMode)o;
        return this.name.equals(other.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String toString() {
        return this.name();
    }
}

