/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.basic;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.opentripplanner.utils.lang.DoubleUtils;

public class Ratio {
    private final double ratio;

    private Ratio(double ratio) {
        this.ratio = DoubleUtils.roundTo3Decimals((double)ratio);
    }

    public static Ratio of(double ratio) {
        return Ratio.of(ratio, errMsg -> {
            throw new IllegalArgumentException((String)errMsg);
        }).orElseThrow();
    }

    public static Optional<Ratio> of(double ratio, Consumer<String> validationErrorHandler) {
        if (ratio >= 0.0 && ratio <= 1.0) {
            return Optional.of(new Ratio(ratio));
        }
        validationErrorHandler.accept("Ratio must be in range [0.0, 1.0], but was: " + ratio);
        return Optional.empty();
    }

    public static Optional<Ratio> ofBoxed(@Nullable Double ratio, Consumer<String> validationErrorHandler) {
        if (ratio == null) {
            return Optional.empty();
        }
        return Ratio.of(ratio, validationErrorHandler);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ratio other = (Ratio)o;
        return Double.compare(this.ratio, other.ratio) == 0;
    }

    public int hashCode() {
        return Double.hashCode(this.ratio);
    }

    public String toString() {
        return Double.toString(this.ratio);
    }

    public double asDouble() {
        return this.ratio;
    }
}

