/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.basic;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.opentripplanner.utils.lang.IntUtils;

public class Money
implements Comparable<Money>,
Serializable {
    public static final Currency USD = Currency.getInstance("USD");
    public static final Money ZERO_USD = Money.usDollars(0.0f);
    private final Currency currency;
    private final int amount;

    private Money(Currency currency, int minorUnitAmount) {
        this.currency = Objects.requireNonNull(currency);
        this.amount = minorUnitAmount;
    }

    public static Money euros(float amount) {
        return Money.ofFractionalAmount(Currency.getInstance("EUR"), amount);
    }

    public static Money usDollars(float amount) {
        return Money.ofFractionalAmount(USD, amount);
    }

    public static Money max(Money first, Money second) {
        if (!first.currency.equals(second.currency)) {
            throw new RuntimeException("Can't operate on %s and %s as the currencies are not equal.");
        }
        if (first.greaterThan(second)) {
            return first;
        }
        return second;
    }

    public static Money ofFractionalAmount(Currency currency, float fractionalAmount) {
        Objects.requireNonNull(currency);
        int fractionDigits = currency.getDefaultFractionDigits();
        int amount = IntUtils.round((double)((double)fractionalAmount * Math.pow(10.0, fractionDigits)));
        return new Money(currency, amount);
    }

    public boolean isPositive() {
        return (float)this.amount > 0.0f;
    }

    public boolean isZero() {
        return (float)this.amount == 0.0f;
    }

    @Override
    public int compareTo(Money m) {
        if (m.currency != this.currency) {
            throw new RuntimeException("Can't compare " + String.valueOf(m.currency) + " to " + String.valueOf(this.currency));
        }
        return this.amount - m.amount;
    }

    public BigDecimal fractionalAmount() {
        int fractionDigits = this.currency.getDefaultFractionDigits();
        BigDecimal divisor = BigDecimal.valueOf(Math.pow(10.0, fractionDigits));
        return new BigDecimal(this.amount).setScale(fractionDigits, RoundingMode.HALF_UP).divide(divisor, RoundingMode.HALF_UP);
    }

    public int minorUnitAmount() {
        return this.amount;
    }

    public String localize(Locale loc) {
        NumberFormat nf = NumberFormat.getCurrencyInstance(loc);
        nf.setCurrency(this.currency);
        nf.setMaximumFractionDigits(this.currency.getDefaultFractionDigits());
        return nf.format(this.fractionalAmount());
    }

    public String toString() {
        return this.localize(Locale.ENGLISH);
    }

    public Money minus(Money other) {
        return this.op(other, o -> new Money(this.currency, this.amount - o.amount));
    }

    public Money plus(Money other) {
        return this.op(other, o -> new Money(this.currency, this.amount + o.amount));
    }

    public Money half() {
        return new Money(this.currency, IntUtils.round((double)((float)this.amount / 2.0f)));
    }

    public Money roundDownToNearestFiveMinorUnits() {
        int rounded = this.minorUnitAmount() / 5 * 5;
        return new Money(this.currency, rounded);
    }

    public Money times(int multiplicator) {
        return new Money(this.currency, this.amount * multiplicator);
    }

    public boolean greaterThan(Money other) {
        return this.booleanOp(other, this.amount > other.amount);
    }

    public boolean lessThan(Money other) {
        return this.booleanOp(other, this.amount < other.amount);
    }

    public Currency currency() {
        return this.currency;
    }

    private boolean booleanOp(Money other, boolean result) {
        this.checkCurrencyOrThrow(other);
        return result;
    }

    private Money op(Money other, Function<Money, Money> op) {
        this.checkCurrencyOrThrow(other);
        return op.apply(other);
    }

    private void checkCurrencyOrThrow(Money other) {
        if (!this.currency.equals(other.currency)) {
            throw new IllegalArgumentException("Cannot perform operations on %s and %s because they have unequal currency.".formatted(this, other));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Money) {
            Money other = (Money)obj;
            return other.amount == this.amount && other.currency == this.currency;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.amount);
    }
}

