/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.basic;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.opentripplanner.utils.tostring.ValueObjectToStringBuilder;

public class Distance {
    private static final int MILLIMETERS_PER_M = 1000;
    private static final int MILLIMETERS_PER_KM = 1000000;
    private final int millimeters;

    private Distance(int distanceInMillimeters) {
        this.millimeters = distanceInMillimeters;
    }

    private static Distance of(int distanceInMillimeters) {
        return Distance.of(distanceInMillimeters, errMsg -> {
            throw new IllegalArgumentException((String)errMsg);
        }).orElseThrow();
    }

    private static Optional<Distance> of(int distanceInMillimeters, Consumer<String> validationErrorHandler) {
        if (distanceInMillimeters >= 0) {
            return Optional.of(new Distance(distanceInMillimeters));
        }
        validationErrorHandler.accept("Distance must be greater or equal than 0, but was: " + distanceInMillimeters);
        return Optional.empty();
    }

    private static Optional<Distance> ofBoxed(@Nullable Double value, Consumer<String> validationErrorHandler, int multiplier) {
        if (value == null) {
            return Optional.empty();
        }
        return Distance.of((int)(value * (double)multiplier), validationErrorHandler);
    }

    public static Optional<Distance> ofMetersBoxed(@Nullable Double value, Consumer<String> validationErrorHandler) {
        return Distance.ofBoxed(value, validationErrorHandler, 1000);
    }

    public static Optional<Distance> ofKilometersBoxed(@Nullable Double value, Consumer<String> validationErrorHandler) {
        return Distance.ofBoxed(value, validationErrorHandler, 1000000);
    }

    public int toMeters() {
        double meters = (double)this.millimeters / 1000.0;
        return (int)Math.round(meters);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Distance other = (Distance)o;
        return this.millimeters == other.millimeters;
    }

    public int hashCode() {
        return Integer.hashCode(this.millimeters);
    }

    public String toString() {
        if (this.millimeters > 1000000) {
            return ValueObjectToStringBuilder.of().addNum((Number)((double)this.millimeters / 1000000.0), "km").toString();
        }
        return ValueObjectToStringBuilder.of().addNum((Number)((double)this.millimeters / 1000.0), "m").toString();
    }
}

