/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.configure;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import jakarta.inject.Singleton;
import java.time.LocalDate;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.RealTimeRaptorTransitDataUpdater;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.updater.trip.TimetableSnapshotManager;

@Module
public abstract class TransitModule {
    @Binds
    abstract TransitService bind(DefaultTransitService var1);

    @Provides
    @Singleton
    public static TimetableSnapshotManager timetableSnapshotManager(RealTimeRaptorTransitDataUpdater realtimeRaptorTransitDataUpdater, ConfigModel config, TimetableRepository timetableRepository) {
        return new TimetableSnapshotManager(realtimeRaptorTransitDataUpdater, config.routerConfig().updaterConfig().timetableSnapshotParameters(), () -> LocalDate.now(timetableRepository.getTimeZone()));
    }

    @Provides
    @Singleton
    public static RealTimeRaptorTransitDataUpdater realtimeRaptorTransitDataUpdater(TimetableRepository timetableRepository) {
        return new RealTimeRaptorTransitDataUpdater(timetableRepository);
    }

    @Provides
    public static TimetableSnapshot timetableSnapshot(TimetableSnapshotManager manager) {
        return manager.getTimetableSnapshot();
    }
}

