/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.api.request;

import java.time.LocalDate;
import java.util.Objects;
import org.opentripplanner.transit.api.model.FilterValues;
import org.opentripplanner.transit.api.request.TripRequestBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class TripRequest {
    private final FilterValues<FeedScopedId> includeAgencies;
    private final FilterValues<FeedScopedId> includeRoutes;
    private final FilterValues<FeedScopedId> excludeAgencies;
    private final FilterValues<FeedScopedId> excludeRoutes;
    private final FilterValues<String> includeNetexInternalPlanningCodes;
    private final FilterValues<LocalDate> includeServiceDates;

    TripRequest(FilterValues<FeedScopedId> includeAgencies, FilterValues<FeedScopedId> includeRoutes, FilterValues<FeedScopedId> excludeAgencies, FilterValues<FeedScopedId> excludeRoutes, FilterValues<String> includeNetexInternalPlanningCodes, FilterValues<LocalDate> includeServiceDates) {
        this.includeAgencies = includeAgencies;
        this.includeRoutes = includeRoutes;
        this.excludeAgencies = excludeAgencies;
        this.excludeRoutes = excludeRoutes;
        this.includeNetexInternalPlanningCodes = includeNetexInternalPlanningCodes;
        this.includeServiceDates = includeServiceDates;
    }

    public static TripRequestBuilder of() {
        return new TripRequestBuilder();
    }

    public FilterValues<FeedScopedId> includeAgencies() {
        return this.includeAgencies;
    }

    public FilterValues<FeedScopedId> includeRoutes() {
        return this.includeRoutes;
    }

    public FilterValues<FeedScopedId> excludeAgencies() {
        return this.excludeAgencies;
    }

    public FilterValues<FeedScopedId> excludeRoutes() {
        return this.excludeRoutes;
    }

    public FilterValues<String> includeNetexInternalPlanningCodes() {
        return this.includeNetexInternalPlanningCodes;
    }

    public FilterValues<LocalDate> includeServiceDates() {
        return this.includeServiceDates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TripRequest)) {
            return false;
        }
        TripRequest that = (TripRequest)o;
        return Objects.equals(this.includeAgencies, that.includeAgencies) && Objects.equals(this.includeRoutes, that.includeRoutes) && Objects.equals(this.excludeAgencies, that.excludeAgencies) && Objects.equals(this.excludeRoutes, that.excludeRoutes) && Objects.equals(this.includeNetexInternalPlanningCodes, that.includeNetexInternalPlanningCodes) && Objects.equals(this.includeServiceDates, that.includeServiceDates);
    }

    public int hashCode() {
        return Objects.hash(this.includeAgencies, this.includeRoutes, this.excludeAgencies, this.excludeRoutes, this.includeNetexInternalPlanningCodes, this.includeServiceDates);
    }

    public String toString() {
        return ToStringBuilder.of(TripRequest.class).addObj("includeAgencies", this.includeAgencies).addObj("includeRoutes", this.includeRoutes).addObj("excludeAgencies", this.excludeAgencies).addObj("excludeRoutes", this.excludeRoutes).addObj("includeNetexInternalPlanningCodes", this.includeNetexInternalPlanningCodes).addObj("includeServiceDates", this.includeServiceDates).toString();
    }
}

