/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.api.request;

import java.time.LocalDate;
import org.opentripplanner.transit.api.model.FilterValues;
import org.opentripplanner.transit.api.request.TripOnServiceDateRequestBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.TripAlteration;

public class TripOnServiceDateRequest {
    private final FilterValues<LocalDate> serviceDates;
    private final FilterValues<FeedScopedId> agencies;
    private final FilterValues<FeedScopedId> routes;
    private final FilterValues<FeedScopedId> serviceJourneys;
    private final FilterValues<FeedScopedId> replacementFor;
    private final FilterValues<String> netexInternalPlanningCodes;
    private final FilterValues<TripAlteration> alterations;

    TripOnServiceDateRequest(FilterValues<LocalDate> serviceDates, FilterValues<FeedScopedId> agencies, FilterValues<FeedScopedId> routes, FilterValues<FeedScopedId> serviceJourneys, FilterValues<FeedScopedId> replacementFor, FilterValues<String> netexInternalPlanningCodes, FilterValues<TripAlteration> alterations) {
        this.serviceDates = serviceDates;
        this.agencies = agencies;
        this.routes = routes;
        this.serviceJourneys = serviceJourneys;
        this.replacementFor = replacementFor;
        this.netexInternalPlanningCodes = netexInternalPlanningCodes;
        this.alterations = alterations;
    }

    public static TripOnServiceDateRequestBuilder of(FilterValues<LocalDate> serviceDates) {
        return new TripOnServiceDateRequestBuilder(serviceDates);
    }

    public FilterValues<FeedScopedId> agencies() {
        return this.agencies;
    }

    public FilterValues<FeedScopedId> routes() {
        return this.routes;
    }

    public FilterValues<FeedScopedId> serviceJourneys() {
        return this.serviceJourneys;
    }

    public FilterValues<FeedScopedId> replacementFor() {
        return this.replacementFor;
    }

    public FilterValues<String> netexInternalPlanningCodes() {
        return this.netexInternalPlanningCodes;
    }

    public FilterValues<TripAlteration> alterations() {
        return this.alterations;
    }

    public FilterValues<LocalDate> serviceDates() {
        return this.serviceDates;
    }
}

