/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.api.model;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.transit.api.model.EmptyIsEverythingFilter;
import org.opentripplanner.transit.api.model.NullIsEverythingFilter;
import org.opentripplanner.transit.api.model.RequiredFilterValues;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public abstract class FilterValues<E> {
    @Nullable
    protected final Collection<E> values;
    private final String name;

    FilterValues(String name, @Nullable Collection<E> values) {
        this.name = name;
        this.values = values;
    }

    public static <E> FilterValues<E> ofEmptyIsEverything(String name, @Nullable Collection<E> values) {
        return new EmptyIsEverythingFilter<E>(name, values);
    }

    public static <E> FilterValues<E> ofNullIsEverything(String name, @Nullable Collection<E> values) {
        return new NullIsEverythingFilter<E>(name, values);
    }

    public static <E> RequiredFilterValues<E> ofRequired(String name, @Nullable Collection<E> values) {
        return new RequiredFilterValues<E>(name, values);
    }

    public abstract boolean includeEverything();

    public Collection<E> get() {
        if (this.includeEverything()) {
            throw new NoSuchElementException("Filter values for filter %s effectively don't filter, use includeEverything() before calling this method.".formatted(this.name));
        }
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterValues)) {
            return false;
        }
        FilterValues that = (FilterValues)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.name);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("name", this.name).addCol("values", this.values).toString();
    }
}

