/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search.strategy;

import java.util.Set;
import org.opentripplanner.astar.spi.RemainingWeightHeuristic;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.FreeEdge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.VehicleRentalState;

public class EuclideanRemainingWeightHeuristic
implements RemainingWeightHeuristic<State> {
    private static final Float DEFAULT_MAX_CAR_SPEED = Float.valueOf(40.0f);
    private double lat;
    private double lon;
    private double maxStreetSpeed;
    private double walkingSpeed;
    private boolean arriveBy;
    private float maxCarSpeed;

    public EuclideanRemainingWeightHeuristic() {
        this(DEFAULT_MAX_CAR_SPEED);
    }

    public EuclideanRemainingWeightHeuristic(Float maxCarSpeed) {
        this.maxCarSpeed = (maxCarSpeed != null ? maxCarSpeed : DEFAULT_MAX_CAR_SPEED).floatValue();
    }

    public void initialize(StreetMode streetMode, Set<Vertex> toVertices, boolean arriveBy, RoutingPreferences preferences) {
        Edge edge;
        Vertex target = toVertices.iterator().next();
        this.maxStreetSpeed = this.getStreetSpeedUpperBound(preferences, streetMode);
        this.walkingSpeed = preferences.walk().speed();
        this.arriveBy = arriveBy;
        if (target.getDegreeIn() == 1 && (edge = target.getIncoming().iterator().next()) instanceof FreeEdge) {
            target = edge.getFromVertex();
        }
        this.lat = target.getLat();
        this.lon = target.getLon();
    }

    private double getStreetSpeedUpperBound(RoutingPreferences preferences, StreetMode streetMode) {
        if (streetMode.includesDriving()) {
            return this.maxCarSpeed;
        }
        if (streetMode.includesBiking()) {
            return preferences.bike().speed();
        }
        if (streetMode.includesScooter()) {
            return preferences.scooter().speed();
        }
        return preferences.walk().speed();
    }

    @Override
    public double estimateRemainingWeight(State s) {
        Vertex sv = s.getVertex();
        double euclideanDistance = SphericalDistanceLibrary.fastDistance(sv.getLat(), sv.getLon(), this.lat, this.lon);
        boolean useWalkSpeed = this.arriveBy ? s.getVehicleRentalState() == VehicleRentalState.BEFORE_RENTING : s.isVehicleParked() || s.getVehicleRentalState() == VehicleRentalState.HAVE_RENTED;
        double streetSpeed = useWalkSpeed ? this.walkingSpeed : this.maxStreetSpeed;
        return euclideanDistance / streetSpeed;
    }
}

