/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search.strategy;

import java.io.Serializable;
import java.util.Objects;
import org.opentripplanner.astar.spi.DominanceFunction;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.search.state.State;

public abstract class DominanceFunctions
implements Serializable,
DominanceFunction<State> {
    @Override
    public boolean betterOrEqualAndComparable(State a, State b) {
        if (!a.isCompatibleVehicleRentalState(b)) {
            return false;
        }
        if (a.isRentingVehicle() && !Objects.equals(a.getVehicleRentalNetwork(), b.getVehicleRentalNetwork())) {
            return false;
        }
        if (a.isVehicleParked() != b.isVehicleParked()) {
            return false;
        }
        if (a.getCarPickupState() != b.getCarPickupState()) {
            return false;
        }
        if (a.hasEnteredNoThruTrafficArea() != b.hasEnteredNoThruTrafficArea()) {
            return false;
        }
        if (a.isInsideNoRentalDropOffArea() != b.isInsideNoRentalDropOffArea()) {
            return false;
        }
        if (a.backEdge != b.getBackEdge() && a.backEdge instanceof StreetEdge && a.getBackMode() != null && a.getBackMode().isInCar() && a.getRequest().isCloseToStartOrEnd(a.getVertex())) {
            return false;
        }
        return this.betterOrEqual(a, b);
    }

    protected abstract boolean betterOrEqual(State var1, State var2);

    public static class Pareto
    extends DominanceFunctions {
        @Override
        public boolean betterOrEqual(State a, State b) {
            double EPSILON = 1.0E-4;
            return (double)a.getElapsedTimeSeconds() <= (double)b.getElapsedTimeSeconds() + 1.0E-4 && a.getWeight() <= b.getWeight() + 1.0E-4;
        }
    }

    public static class LeastWalk
    extends DominanceFunctions {
        @Override
        protected boolean betterOrEqual(State a, State b) {
            return a.getWalkDistance() <= b.getWalkDistance();
        }
    }

    public static class EarliestArrival
    extends DominanceFunctions {
        @Override
        public boolean betterOrEqual(State a, State b) {
            return a.getElapsedTimeSeconds() <= b.getElapsedTimeSeconds();
        }
    }

    public static class MinimumWeight
    extends DominanceFunctions {
        @Override
        public boolean betterOrEqual(State a, State b) {
            return a.weight <= b.weight;
        }
    }
}

