/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opentripplanner.routing.algorithm.mapping.StreetModeToFormFactorMapper;
import org.opentripplanner.routing.algorithm.mapping.StreetModeToRentalTraverseModeMapper;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.state.CarPickupState;
import org.opentripplanner.street.search.state.VehicleRentalState;

public class StateData
implements Cloneable {
    protected boolean vehicleParked;
    protected VehicleRentalState vehicleRentalState;
    protected boolean mayKeepRentedVehicleAtDestination;
    protected CarPickupState carPickupState;
    protected TraverseMode currentMode;
    protected TraverseMode backMode;
    protected boolean backWalkingBike;
    public String vehicleRentalNetwork;
    public RentalFormFactor rentalVehicleFormFactor;
    protected boolean enteredNoThroughTrafficArea;
    protected boolean insideNoRentalDropOffArea = false;
    public Set<String> noRentalDropOffZonesAtStartOfReverseSearch = Set.of();

    private StateData(StreetMode requestMode) {
        this.currentMode = switch (requestMode) {
            default -> throw new MatchException(null, null);
            case StreetMode.NOT_SET, StreetMode.WALK, StreetMode.BIKE_RENTAL, StreetMode.SCOOTER_RENTAL, StreetMode.CAR_RENTAL, StreetMode.FLEXIBLE -> TraverseMode.WALK;
            case StreetMode.BIKE, StreetMode.BIKE_TO_PARK -> TraverseMode.BICYCLE;
            case StreetMode.CAR, StreetMode.CAR_TO_PARK, StreetMode.CAR_PICKUP, StreetMode.CAR_HAILING -> TraverseMode.CAR;
        };
    }

    public static List<StateData> getInitialStateDatas(StreetSearchRequest request) {
        VehicleRentalPreferences rentalPreferences = request.preferences().rental(request.mode());
        return StateData.getInitialStateDatas(request.mode(), request.arriveBy(), rentalPreferences != null ? rentalPreferences.allowArrivingInRentedVehicleAtDestination() : false);
    }

    public static StateData getBaseCaseStateData(StreetSearchRequest request) {
        List<StateData> baseCaseDatas;
        VehicleRentalPreferences rentalPreferences = request.preferences().rental(request.mode());
        List<StateData> stateDatas = StateData.getInitialStateDatas(request.mode(), request.arriveBy(), rentalPreferences != null ? rentalPreferences.allowArrivingInRentedVehicleAtDestination() : false);
        switch (request.mode()) {
            default: {
                throw new MatchException(null, null);
            }
            case NOT_SET: 
            case WALK: 
            case FLEXIBLE: 
            case BIKE: 
            case BIKE_TO_PARK: 
            case CAR: 
            case CAR_TO_PARK: {
                List<StateData> list = stateDatas;
                break;
            }
            case CAR_PICKUP: 
            case CAR_HAILING: {
                List<StateData> list = stateDatas.stream().filter(d -> d.carPickupState == CarPickupState.IN_CAR).toList();
                break;
            }
            case BIKE_RENTAL: 
            case SCOOTER_RENTAL: 
            case CAR_RENTAL: {
                List<StateData> list = baseCaseDatas = request.arriveBy() ? stateDatas.stream().filter(d -> d.vehicleRentalState == VehicleRentalState.RENTING_FROM_STATION || d.vehicleRentalState == VehicleRentalState.RENTING_FLOATING).toList() : stateDatas;
            }
        }
        if (baseCaseDatas.size() != 1) {
            throw new IllegalStateException("Unable to create only a single state for %s".formatted(request));
        }
        return baseCaseDatas.get(0);
    }

    private static List<StateData> getInitialStateDatas(StreetMode requestMode, boolean arriveBy, boolean allowArrivingInRentedVehicleAtDestination) {
        ArrayList<StateData> res = new ArrayList<StateData>();
        StateData proto = new StateData(requestMode);
        if (requestMode.includesPickup()) {
            StateData inCarPickupStateData = proto.clone();
            inCarPickupStateData.carPickupState = CarPickupState.IN_CAR;
            inCarPickupStateData.currentMode = TraverseMode.CAR;
            res.add(inCarPickupStateData);
            StateData walkingPickupStateData = proto.clone();
            walkingPickupStateData.carPickupState = arriveBy ? CarPickupState.WALK_FROM_DROP_OFF : CarPickupState.WALK_TO_PICKUP;
            walkingPickupStateData.currentMode = TraverseMode.WALK;
            res.add(walkingPickupStateData);
        } else if (requestMode.includesRenting()) {
            if (arriveBy) {
                TraverseMode vehicleMode = StreetModeToRentalTraverseModeMapper.map(requestMode);
                RentalFormFactor formFactor = StreetModeToFormFactorMapper.map(requestMode);
                if (allowArrivingInRentedVehicleAtDestination) {
                    StateData keptVehicleStateData = proto.clone();
                    keptVehicleStateData.vehicleRentalState = VehicleRentalState.RENTING_FROM_STATION;
                    keptVehicleStateData.currentMode = vehicleMode;
                    keptVehicleStateData.mayKeepRentedVehicleAtDestination = true;
                    res.add(keptVehicleStateData);
                }
                StateData floatingRentalStateData = proto.clone();
                floatingRentalStateData.vehicleRentalState = VehicleRentalState.RENTING_FLOATING;
                floatingRentalStateData.rentalVehicleFormFactor = formFactor;
                floatingRentalStateData.currentMode = vehicleMode;
                res.add(floatingRentalStateData);
                StateData stationReturnedStateData = proto.clone();
                stationReturnedStateData.vehicleRentalState = VehicleRentalState.HAVE_RENTED;
                stationReturnedStateData.currentMode = TraverseMode.WALK;
                res.add(stationReturnedStateData);
            } else {
                StateData beforeRentalStateData = proto.clone();
                beforeRentalStateData.vehicleRentalState = VehicleRentalState.BEFORE_RENTING;
                res.add(beforeRentalStateData);
            }
        } else if (requestMode.includesParking()) {
            StateData parkAndRideStateData = proto.clone();
            parkAndRideStateData.vehicleParked = arriveBy;
            parkAndRideStateData.currentMode = parkAndRideStateData.vehicleParked ? TraverseMode.WALK : (requestMode.includesBiking() ? TraverseMode.BICYCLE : TraverseMode.CAR);
            res.add(parkAndRideStateData);
        } else {
            res.add(proto.clone());
        }
        return res;
    }

    protected StateData clone() {
        try {
            return (StateData)super.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new IllegalStateException("This is not happening");
        }
    }
}

