/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search.state;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.astar.spi.AStarState;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalEdge;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.intersection_model.IntersectionTraversalCalculator;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.state.CarPickupState;
import org.opentripplanner.street.search.state.StateData;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.street.search.state.VehicleRentalState;
import org.opentripplanner.utils.lang.ObjectUtils;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class State
implements AStarState<State, Edge, Vertex>,
Cloneable {
    private static final State[] EMPTY_STATES = new State[0];
    private final StreetSearchRequest request;
    protected long time_ms;
    public double weight;
    protected Vertex vertex;
    protected State backState;
    public Edge backEdge;
    public StateData stateData;
    public double walkDistance;

    public State(Vertex vertex, StreetSearchRequest streetSearchRequest) {
        this(vertex, streetSearchRequest.startTime(), StateData.getBaseCaseStateData(streetSearchRequest), streetSearchRequest);
    }

    public State(Vertex vertex, Instant startTime, StateData stateData, StreetSearchRequest request) {
        this.request = request;
        this.weight = 0.0;
        this.vertex = vertex;
        this.backState = null;
        this.stateData = stateData;
        if (request.arriveBy() && !vertex.rentalRestrictions().noDropOffNetworks().isEmpty()) {
            this.stateData.noRentalDropOffZonesAtStartOfReverseSearch = vertex.rentalRestrictions().noDropOffNetworks();
        }
        this.walkDistance = 0.0;
        this.time_ms = startTime.toEpochMilli();
    }

    public static Collection<State> getInitialStates(Set<Vertex> vertices, StreetSearchRequest streetSearchRequest) {
        ArrayList<State> states = new ArrayList<State>();
        for (Vertex vertex : vertices) {
            for (StateData stateData : StateData.getInitialStateDatas(streetSearchRequest)) {
                states.add(new State(vertex, streetSearchRequest.startTime(), stateData, streetSearchRequest));
            }
        }
        return states;
    }

    public static State[] ofNullable(@Nullable State u) {
        if (u == null) {
            return EMPTY_STATES;
        }
        return new State[]{u};
    }

    public static State[] ofNullable(@Nullable State s1, @Nullable State s2) {
        if (s1 == null && s2 == null) {
            return EMPTY_STATES;
        }
        if (s1 == null) {
            return new State[]{s2};
        }
        if (s2 == null) {
            return new State[]{s1};
        }
        return new State[]{s1, s2};
    }

    public static State[] empty() {
        return EMPTY_STATES;
    }

    public static boolean isEmpty(State[] s) {
        return s.length == 0;
    }

    public static State[] ofStream(Stream<State> states) {
        return (State[])states.filter(Objects::nonNull).toArray(State[]::new);
    }

    public StateEditor edit(Edge e) {
        return new StateEditor(this, e);
    }

    public CarPickupState getCarPickupState() {
        return this.stateData.carPickupState;
    }

    private long millisecondsToSeconds(long milliseconds) {
        if (this.request.arriveBy()) {
            return milliseconds / 1000L;
        }
        return (milliseconds + 999L) / 1000L;
    }

    @Override
    public long getTimeSeconds() {
        return this.millisecondsToSeconds(this.time_ms);
    }

    public long getTimeMilliseconds() {
        return this.time_ms;
    }

    @Override
    public long getElapsedTimeSeconds() {
        return (this.getElapsedTimeMilliseconds() + 999L) / 1000L;
    }

    public long getElapsedTimeMilliseconds() {
        return Math.abs(this.getTimeMilliseconds() - this.request.startTime().toEpochMilli());
    }

    public boolean isCompatibleVehicleRentalState(State state) {
        return this.stateData.vehicleRentalState == state.stateData.vehicleRentalState && this.stateData.mayKeepRentedVehicleAtDestination == state.stateData.mayKeepRentedVehicleAtDestination;
    }

    public boolean isRentingVehicleFromStation() {
        return this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FROM_STATION;
    }

    public boolean isRentingFloatingVehicle() {
        return this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FLOATING;
    }

    public boolean isRentingVehicle() {
        return this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FROM_STATION || this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FLOATING;
    }

    private boolean vehicleRentalIsFinished() {
        return this.stateData.vehicleRentalState == VehicleRentalState.HAVE_RENTED || this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FLOATING && !this.stateData.insideNoRentalDropOffArea || this.getRequest().preferences().rental(this.getRequest().mode()).allowArrivingInRentedVehicleAtDestination() && this.stateData.mayKeepRentedVehicleAtDestination && this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FROM_STATION;
    }

    private boolean vehicleRentalNotStarted() {
        return this.stateData.vehicleRentalState == VehicleRentalState.BEFORE_RENTING;
    }

    public VehicleRentalState getVehicleRentalState() {
        return this.stateData.vehicleRentalState;
    }

    public boolean isVehicleParked() {
        return this.stateData.vehicleParked;
    }

    @Override
    public boolean isFinal() {
        boolean vehicleParkAndRideOk;
        boolean vehicleRentingOk;
        boolean parkAndRide = this.request.mode().includesParking();
        if (this.request.arriveBy()) {
            vehicleRentingOk = !this.request.mode().includesRenting() || !this.isRentingVehicle();
            vehicleParkAndRideOk = !parkAndRide || !this.isVehicleParked();
        } else {
            vehicleRentingOk = !this.request.mode().includesRenting() || this.vehicleRentalNotStarted() || this.vehicleRentalIsFinished();
            vehicleParkAndRideOk = !parkAndRide || this.isVehicleParked();
        }
        return vehicleRentingOk && vehicleParkAndRideOk;
    }

    public RentalFormFactor vehicleRentalFormFactor() {
        return this.stateData.rentalVehicleFormFactor;
    }

    public double getWalkDistance() {
        return this.walkDistance;
    }

    @Override
    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public int getTimeDeltaSeconds() {
        return (int)this.millisecondsToSeconds(this.getTimeDeltaMilliseconds());
    }

    public int getTimeDeltaMilliseconds() {
        return this.backState != null ? (int)(this.getTimeMilliseconds() - this.backState.getTimeMilliseconds()) : 0;
    }

    public double getWeightDelta() {
        return this.weight - this.backState.weight;
    }

    @Override
    public State getBackState() {
        return this.backState;
    }

    public TraverseMode getBackMode() {
        return this.stateData.backMode;
    }

    public boolean isBackWalkingBike() {
        return this.stateData.backWalkingBike;
    }

    @Override
    public Edge getBackEdge() {
        return this.backEdge;
    }

    @Override
    public void initBackEdge(Edge initialBackEdge) {
        this.backEdge = (Edge)ObjectUtils.requireNotInitialized((Object)this.backEdge, (Object)initialBackEdge);
    }

    @Override
    public StreetSearchRequest getRequest() {
        return this.request;
    }

    public RoutingPreferences getPreferences() {
        return this.request.preferences();
    }

    public TraverseMode currentMode() {
        return this.stateData.currentMode;
    }

    @Override
    public Instant getTime() {
        return Instant.ofEpochSecond(this.millisecondsToSeconds(this.time_ms));
    }

    public Instant getTimeAccurate() {
        return Instant.ofEpochMilli(this.time_ms);
    }

    public String getVehicleRentalNetwork() {
        return this.stateData.vehicleRentalNetwork;
    }

    public boolean unknownRentalNetwork() {
        return this.stateData.vehicleRentalNetwork == null;
    }

    @Override
    public State reverse() {
        State orig = this;
        State ret = orig.reversedClone();
        while (orig.getBackState() != null) {
            Edge edge = orig.getBackEdge();
            StateEditor editor = ret.edit(edge);
            editor.setFromState(orig);
            editor.incrementTimeInMilliseconds(orig.getAbsTimeDeltaMilliseconds());
            editor.incrementWeight(orig.getWeightDelta());
            editor.incrementWalkDistance(orig.getWalkDistanceDelta());
            editor.setBackMode(orig.getBackMode());
            if (orig.isRentingVehicle() && !orig.getBackState().isRentingVehicle()) {
                Vertex vertex = orig.vertex;
                if (vertex instanceof VehicleRentalPlaceVertex) {
                    stationVertex = (VehicleRentalPlaceVertex)vertex;
                    editor.dropOffRentedVehicleAtStation(((VehicleRentalEdge)edge).formFactor, stationVertex.getStation().network(), false);
                } else {
                    editor.dropFloatingVehicle(orig.stateData.rentalVehicleFormFactor, orig.getVehicleRentalNetwork(), false);
                }
            } else if (!orig.isRentingVehicle() && orig.getBackState().isRentingVehicle()) {
                stationVertex = (VehicleRentalPlaceVertex)orig.vertex;
                if (orig.getBackState().isRentingVehicleFromStation()) {
                    editor.beginVehicleRentingAtStation(((VehicleRentalEdge)edge).formFactor, stationVertex.getStation().network(), orig.backState.mayKeepRentedVehicleAtDestination(), false);
                } else if (orig.getBackState().isRentingFloatingVehicle()) {
                    editor.beginFloatingVehicleRenting(((VehicleRentalEdge)edge).formFactor, stationVertex.getStation().network(), false);
                }
            }
            if (orig.isVehicleParked() != orig.getBackState().isVehicleParked()) {
                editor.setVehicleParked(true, orig.getBackState().currentMode());
            }
            ret = editor.makeState();
            orig = orig.getBackState();
        }
        return ret;
    }

    public boolean hasEnteredNoThruTrafficArea() {
        return this.stateData.enteredNoThroughTrafficArea;
    }

    public boolean mayKeepRentedVehicleAtDestination() {
        return this.stateData.mayKeepRentedVehicleAtDestination;
    }

    public IntersectionTraversalCalculator intersectionTraversalCalculator() {
        return this.request.intersectionTraversalCalculator();
    }

    public DataOverlayContext dataOverlayContext() {
        return this.request.dataOverlayContext();
    }

    public boolean isInsideNoRentalDropOffArea() {
        return this.stateData.insideNoRentalDropOffArea;
    }

    public boolean containsModeCar() {
        for (State state = this; state != null; state = state.getBackState()) {
            if (!state.currentMode().isInCar()) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnlyWalkMode() {
        State s = this;
        while (s != null) {
            if (!s.stateData.currentMode.isWalking()) {
                return false;
            }
            s = s.backState;
        }
        return true;
    }

    protected State clone() {
        State ret;
        try {
            ret = (State)super.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new IllegalStateException("This is not happening");
        }
        return ret;
    }

    public String toString() {
        return ToStringBuilder.of(State.class).addDateTime("time", this.getTime()).addNum("weight", (Number)this.weight).addObj("vertex", (Object)this.vertex).addBoolIfTrue("VEHICLE_RENT", Boolean.valueOf(this.isRentingVehicle())).addEnum("formFactor", (Enum)this.vehicleRentalFormFactor()).addBoolIfTrue("RENTING_FROM_STATION", Boolean.valueOf(this.isRentingVehicleFromStation())).addBoolIfTrue("RENTING_FREE_FLOATING", Boolean.valueOf(this.isRentingFloatingVehicle() && !this.isRentingVehicleFromStation())).addBoolIfTrue("VEHICLE_PARKED", Boolean.valueOf(this.isVehicleParked())).toString();
    }

    void checkNegativeWeight() {
        double dw = this.weight - this.backState.weight;
        if (dw < 0.0) {
            throw new NegativeWeightException(dw + " on edge " + String.valueOf(this.backEdge));
        }
    }

    private int getAbsTimeDeltaMilliseconds() {
        return Math.abs(this.getTimeDeltaMilliseconds());
    }

    private double getWalkDistanceDelta() {
        if (this.backState != null) {
            return Math.abs(this.walkDistance - this.backState.walkDistance);
        }
        return 0.0;
    }

    private State reversedClone() {
        StreetSearchRequest reversedRequest = this.request.copyOfReversed(this.getTime()).withPreferences(p -> {
            p.withCar(c -> c.withRental(r -> r.withUseAvailabilityInformation(false)));
            p.withBike(b -> b.withRental(r -> r.withUseAvailabilityInformation(false)));
        }).build();
        StateData newStateData = this.stateData.clone();
        newStateData.backMode = null;
        return new State(this.vertex, this.getTime(), newStateData, reversedRequest);
    }

    private static class NegativeWeightException
    extends RuntimeException {
        public NegativeWeightException(String message) {
            super(message);
        }
    }
}

