/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search.state;

import java.util.Collection;
import java.util.Optional;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.state.State;

public class EdgeTraverser {
    public static Optional<State> traverseEdges(State s, Collection<Edge> edges) {
        State state = s;
        for (Edge e : edges) {
            State[] afterTraversal = (State[])e.traverse(state);
            if (afterTraversal.length > 1) {
                throw new IllegalStateException("Expected only a single state returned from edge %s but received %s".formatted(e, afterTraversal.length));
            }
            if (State.isEmpty(afterTraversal)) {
                return Optional.empty();
            }
            state = afterTraversal[0];
        }
        return Optional.ofNullable(state);
    }
}

