/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.street.search.TraverseMode;

public class TraverseModeSet
implements Cloneable,
Serializable {
    private static final int MODE_BICYCLE = 1;
    private static final int MODE_WALK = 2;
    private static final int MODE_CAR = 4;
    private static final int MODE_ALL = 7;
    private byte modes = 0;

    public TraverseModeSet(TraverseMode ... modes) {
        for (TraverseMode mode : modes) {
            this.modes = (byte)(this.modes | this.getMaskForMode(mode));
        }
    }

    public TraverseModeSet(Collection<TraverseMode> modeList) {
        this(modeList.toArray(new TraverseMode[0]));
    }

    public static TraverseModeSet allModes() {
        TraverseModeSet modes = new TraverseModeSet(new TraverseMode[0]);
        modes.modes = (byte)7;
        return modes;
    }

    public boolean getBicycle() {
        return (this.modes & 1) != 0;
    }

    public void setBicycle(boolean bicycle) {
        this.modes = bicycle ? (byte)(this.modes | 1) : (byte)(this.modes & 0xFFFFFFFE);
    }

    public boolean getWalk() {
        return (this.modes & 2) != 0;
    }

    public void setWalk(boolean walk) {
        this.modes = walk ? (byte)(this.modes | 2) : (byte)(this.modes & 0xFFFFFFFD);
    }

    public boolean getCar() {
        return (this.modes & 4) != 0;
    }

    public void setCar(boolean car) {
        this.modes = car ? (byte)(this.modes | 4) : (byte)(this.modes & 0xFFFFFFFB);
    }

    public List<TraverseMode> getModes() {
        ArrayList<TraverseMode> modeList = new ArrayList<TraverseMode>();
        for (TraverseMode mode : TraverseMode.values()) {
            if ((this.modes & this.getMaskForMode(mode)) == 0) continue;
            modeList.add(mode);
        }
        return modeList;
    }

    public boolean isValid() {
        return this.modes != 0;
    }

    public boolean contains(TraverseMode mode) {
        return (this.modes & this.getMaskForMode(mode)) != 0;
    }

    public void clear() {
        this.modes = 0;
    }

    public int hashCode() {
        return this.modes;
    }

    public boolean equals(Object other) {
        if (other instanceof TraverseModeSet) {
            return this.modes == ((TraverseModeSet)other).modes;
        }
        return false;
    }

    public TraverseModeSet clone() {
        try {
            return (TraverseModeSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (TraverseMode mode : TraverseMode.values()) {
            int mask = this.getMaskForMode(mode);
            if (mask == 0 || (this.modes & mask) != mask) continue;
            if (!out.isEmpty()) {
                out.append(", ");
            }
            out.append((Object)mode);
        }
        return "TraverseMode (" + String.valueOf(out) + ")";
    }

    private int getMaskForMode(TraverseMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case TraverseMode.BICYCLE, TraverseMode.SCOOTER -> 1;
            case TraverseMode.WALK -> 2;
            case TraverseMode.CAR -> 4;
            case TraverseMode.FLEX -> 0;
        };
    }
}

