/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.LocalizedString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.DisposableEdgeCollection;
import org.opentripplanner.routing.linking.SameEdgeAdjuster;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.street.model.edge.LinkingDirection;
import org.opentripplanner.street.model.edge.TemporaryFreeEdge;
import org.opentripplanner.street.model.vertex.StationCentroidVertex;
import org.opentripplanner.street.model.vertex.TemporaryStreetLocation;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryVerticesContainer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TemporaryVerticesContainer.class);
    private final Graph graph;
    private final Set<DisposableEdgeCollection> tempEdges;
    private final Set<Vertex> fromVertices;
    private final Set<Vertex> toVertices;
    private final GenericLocation from;
    private final GenericLocation to;
    private final VertexLinker vertexLinker;
    private final Function<FeedScopedId, Collection<FeedScopedId>> resolveSiteIds;

    public TemporaryVerticesContainer(Graph graph, VertexLinker linker, Function<FeedScopedId, Collection<FeedScopedId>> resolveSiteIds, GenericLocation from, GenericLocation to, StreetMode accessMode, StreetMode egressMode) {
        this.resolveSiteIds = resolveSiteIds;
        this.tempEdges = new HashSet<DisposableEdgeCollection>();
        this.graph = graph;
        this.vertexLinker = linker;
        this.from = from;
        this.to = to;
        this.fromVertices = this.getStreetVerticesForLocation(from, accessMode, false, this.tempEdges);
        this.toVertices = this.getStreetVerticesForLocation(to, egressMode, true, this.tempEdges);
        this.checkIfVerticesFound();
        if (this.fromVertices != null && this.toVertices != null) {
            for (Vertex fromVertex : this.fromVertices) {
                for (Vertex toVertex : this.toVertices) {
                    this.tempEdges.add(SameEdgeAdjuster.adjust(fromVertex, toVertex, graph));
                }
            }
        }
    }

    @Override
    public void close() {
        this.tempEdges.forEach(DisposableEdgeCollection::disposeEdges);
    }

    public Set<Vertex> getFromVertices() {
        return this.fromVertices;
    }

    public Set<Vertex> getToVertices() {
        return this.toVertices;
    }

    public Set<TransitStopVertex> getFromStopVertices() {
        if (this.from.stopId == null) {
            return Set.of();
        }
        return this.findStopOrChildStopVertices(this.from.stopId);
    }

    public Set<TransitStopVertex> getToStopVertices() {
        if (this.to.stopId == null) {
            return Set.of();
        }
        return this.findStopOrChildStopVertices(this.to.stopId);
    }

    @Nullable
    private Set<Vertex> getStreetVerticesForLocation(GenericLocation location, StreetMode streetMode, boolean endVertex, Set<DisposableEdgeCollection> tempEdges) {
        if (!location.isSpecified()) {
            return null;
        }
        TraverseMode mode = this.getTraverseModeForLinker(streetMode, endVertex);
        if (mode.isInCar()) {
            TransitStopVertex stopVertex;
            if (location.stopId != null && location.getCoordinate() == null && (stopVertex = this.graph.getStopVertex(location.stopId)) != null) {
                WgsCoordinate c = stopVertex.getStop().getCoordinate();
                location = new GenericLocation(location.label, location.stopId, c.latitude(), c.longitude());
            }
        } else if (location.stopId != null) {
            Optional<TransitStopVertex> stopVertex = this.graph.findStopVertex(location.stopId);
            if (stopVertex.isPresent()) {
                return Set.of((Vertex)stopVertex.get());
            }
            Optional<StationCentroidVertex> centroidVertex = this.graph.findStationCentroidVertex(location.stopId);
            if (centroidVertex.isPresent()) {
                return Set.of((Vertex)centroidVertex.get());
            }
            Set<TransitStopVertex> childVertices = this.findStopOrChildStopVertices(location.stopId);
            if (!childVertices.isEmpty()) {
                return childVertices.stream().map(Vertex.class::cast).collect(Collectors.toUnmodifiableSet());
            }
        }
        if (location.getCoordinate() != null) {
            return Set.of(this.createVertexFromCoordinate(location.getCoordinate(), location.label, streetMode, endVertex, tempEdges));
        }
        return null;
    }

    private Set<TransitStopVertex> findStopOrChildStopVertices(FeedScopedId stopId) {
        return this.resolveSiteIds.apply(stopId).stream().flatMap(id -> this.graph.findStopVertex((FeedScopedId)id).stream()).collect(Collectors.toUnmodifiableSet());
    }

    private TraverseMode getTraverseModeForLinker(StreetMode streetMode, boolean endVertex) {
        boolean onlyCarAvailable;
        TraverseMode nonTransitMode = TraverseMode.WALK;
        boolean parkAndRideDepart = streetMode == StreetMode.CAR_TO_PARK && !endVertex;
        boolean bl = onlyCarAvailable = streetMode == StreetMode.CAR;
        if (onlyCarAvailable || parkAndRideDepart) {
            nonTransitMode = TraverseMode.CAR;
        }
        return nonTransitMode;
    }

    private Vertex createVertexFromCoordinate(Coordinate coordinate, @Nullable String label, StreetMode streetMode, boolean endVertex, Set<DisposableEdgeCollection> tempEdges) {
        if (endVertex) {
            LOG.debug("Creating end vertex for {}", (Object)coordinate);
        } else {
            LOG.debug("Creating start vertex for {}", (Object)coordinate);
        }
        I18NString name = label == null || label.isEmpty() ? (endVertex ? new LocalizedString("destination") : new LocalizedString("origin")) : new NonLocalizedString(label);
        TemporaryStreetLocation temporaryStreetLocation = new TemporaryStreetLocation(coordinate, name);
        TraverseMode nonTransitMode = this.getTraverseModeForLinker(streetMode, endVertex);
        tempEdges.add(this.vertexLinker.linkVertexForRequest(temporaryStreetLocation, new TraverseModeSet(nonTransitMode), endVertex ? LinkingDirection.OUTGOING : LinkingDirection.INCOMING, endVertex ? (vertex, streetVertex) -> List.of(TemporaryFreeEdge.createTemporaryFreeEdge(streetVertex, (TemporaryStreetLocation)vertex)) : (vertex, streetVertex) -> List.of(TemporaryFreeEdge.createTemporaryFreeEdge((TemporaryStreetLocation)vertex, streetVertex))));
        if (temporaryStreetLocation.getIncoming().isEmpty() && temporaryStreetLocation.getOutgoing().isEmpty()) {
            LOG.warn("Couldn't link {}", (Object)coordinate);
        }
        temporaryStreetLocation.setWheelchairAccessible(true);
        return temporaryStreetLocation;
    }

    private void checkIfVerticesFound() {
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>();
        if (this.from.isSpecified() && TemporaryVerticesContainer.isDisconnected(this.fromVertices, true)) {
            routingErrors.add(new RoutingError(this.getRoutingErrorCodeForDisconnected(this.from), InputField.FROM_PLACE));
        }
        if (this.to.isSpecified() && TemporaryVerticesContainer.isDisconnected(this.toVertices, false)) {
            routingErrors.add(new RoutingError(this.getRoutingErrorCodeForDisconnected(this.to), InputField.TO_PLACE));
        }
        if (this.fromVertices != null && this.toVertices != null && !Sets.intersection(this.fromVertices, this.toVertices).isEmpty()) {
            routingErrors.add(new RoutingError(RoutingErrorCode.WALKING_BETTER_THAN_TRANSIT, null));
        }
        if (!routingErrors.isEmpty()) {
            throw new RoutingValidationException(routingErrors);
        }
    }

    private static boolean isDisconnected(Set<Vertex> vertices, boolean isFrom) {
        if (vertices == null) {
            return true;
        }
        Predicate<Vertex> isNotTransit = Predicate.not(TransitStopVertex.class::isInstance);
        Predicate<Vertex> hasNoIncoming = v -> v.getIncoming().isEmpty();
        Predicate<Vertex> hasNoOutgoing = v -> v.getOutgoing().isEmpty();
        Predicate<Vertex> isNotConnected = isFrom ? hasNoOutgoing : hasNoIncoming;
        return vertices.stream().allMatch(isNotTransit.and(isNotConnected));
    }

    private RoutingErrorCode getRoutingErrorCodeForDisconnected(GenericLocation location) {
        Coordinate coordinate = location.getCoordinate();
        GeometryFactory gf = GeometryUtils.getGeometryFactory();
        return coordinate != null && this.graph.getConvexHull().disjoint((Geometry)gf.createPoint(coordinate)) ? RoutingErrorCode.OUTSIDE_BOUNDS : RoutingErrorCode.LOCATION_NOT_FOUND;
    }
}

