/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import org.opentripplanner.transit.model.framework.FeedScopedId;

public sealed interface VertexLabel {
    public static VertexLabel string(String label) {
        return new StringLabel(label);
    }

    public static VertexLabel osm(long nodeId, String level) {
        return new OsmNodeOnLevelLabel(nodeId, level);
    }

    public static VertexLabel osm(long nodeId) {
        return new OsmNodeLabel(nodeId);
    }

    public static VertexLabel feedScopedId(FeedScopedId id) {
        return new FeedScopedIdLabel(id);
    }

    public record StringLabel(String value) implements VertexLabel
    {
        @Override
        public String toString() {
            return this.value;
        }
    }

    public record OsmNodeOnLevelLabel(long nodeId, String level) implements VertexLabel
    {
        private static final String TEMPLATE = "osm:node:%s/%s";

        @Override
        public String toString() {
            return TEMPLATE.formatted(this.nodeId, this.level);
        }
    }

    public record OsmNodeLabel(long nodeId) implements VertexLabel
    {
        private static final String TEMPLATE = "osm:node:%s";

        @Override
        public String toString() {
            return TEMPLATE.formatted(this.nodeId);
        }
    }

    public record FeedScopedIdLabel(FeedScopedId id) implements VertexLabel
    {
        @Override
        public String toString() {
            return this.id.toString();
        }
    }

    public record NodeOnWayLabel(long nodeId, long wayId) implements VertexLabel
    {
        private static final String TEMPLATE = "osm:node:%s:way:%s";

        @Override
        public String toString() {
            return TEMPLATE.formatted(this.nodeId, this.wayId);
        }
    }

    public record SubsidiaryVertexLabel(VertexLabel parent, int counter) implements VertexLabel
    {
        @Override
        public String toString() {
            return this.parent.toString() + ":" + this.counter;
        }
    }
}

