/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingEntrance;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.BarrierPassThroughVertex;
import org.opentripplanner.street.model.vertex.BarrierVertex;
import org.opentripplanner.street.model.vertex.ElevatorVertex;
import org.opentripplanner.street.model.vertex.ExitVertex;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.LabelledIntersectionVertex;
import org.opentripplanner.street.model.vertex.OsmBoardingLocationVertex;
import org.opentripplanner.street.model.vertex.OsmVertex;
import org.opentripplanner.street.model.vertex.OsmVertexOnLevel;
import org.opentripplanner.street.model.vertex.SplitterVertex;
import org.opentripplanner.street.model.vertex.StationCentroidVertex;
import org.opentripplanner.street.model.vertex.StationEntranceVertex;
import org.opentripplanner.street.model.vertex.TransitBoardingAreaVertex;
import org.opentripplanner.street.model.vertex.TransitEntranceVertex;
import org.opentripplanner.street.model.vertex.TransitPathwayNodeVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertexBuilder;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.site.BoardingArea;
import org.opentripplanner.transit.model.site.Entrance;
import org.opentripplanner.transit.model.site.PathwayNode;
import org.opentripplanner.transit.model.site.Station;

public class VertexFactory {
    private final Graph graph;

    public VertexFactory(Graph graph) {
        this.graph = graph;
    }

    public TransitBoardingAreaVertex transitBoardingArea(BoardingArea boardingArea) {
        return this.addToGraph(new TransitBoardingAreaVertex(boardingArea));
    }

    public ElevatorVertex elevator(Vertex sourceVertex, String label, String levelName) {
        return this.addToGraph(new ElevatorVertex(sourceVertex, label, levelName));
    }

    public IntersectionVertex intersection(Coordinate edgeCoordinate) {
        return this.addToGraph(new LabelledIntersectionVertex("area splitter at " + String.valueOf(edgeCoordinate), edgeCoordinate.x, edgeCoordinate.y, false, false));
    }

    public IntersectionVertex intersection(String label, double longitude, double latitude) {
        return this.addToGraph(new LabelledIntersectionVertex(label, longitude, latitude, false, false));
    }

    public OsmBoardingLocationVertex osmBoardingLocation(Coordinate coordinate, String label, Set<String> refs, @Nullable I18NString name) {
        return this.addToGraph(new OsmBoardingLocationVertex(label, coordinate.x, coordinate.y, name, refs));
    }

    public SplitterVertex splitter(StreetEdge originalEdge, double x, double y, String uniqueSplitLabel) {
        return this.addToGraph(new SplitterVertex(uniqueSplitLabel, x, y, originalEdge.getName()));
    }

    public BarrierVertex barrier(long nid, Coordinate coordinate, Accessibility wheelchairAccessibility) {
        return this.addToGraph(new BarrierVertex(coordinate.x, coordinate.y, nid, wheelchairAccessibility));
    }

    public ExitVertex exit(long nid, Coordinate coordinate, String exitName) {
        return this.addToGraph(new ExitVertex(coordinate.x, coordinate.y, nid, exitName));
    }

    public StationEntranceVertex stationEntrance(long nid, Coordinate coordinate, String code, Accessibility wheelchairAccessibility) {
        return this.addToGraph(new StationEntranceVertex(coordinate.x, coordinate.y, nid, code, wheelchairAccessibility));
    }

    public OsmVertex osm(Coordinate coordinate, long nid, boolean highwayTrafficLight, boolean crossingTrafficLight) {
        return this.addToGraph(new OsmVertex(coordinate.x, coordinate.y, nid, highwayTrafficLight, crossingTrafficLight));
    }

    public OsmVertex osmOnLinearBarrier(Coordinate coordinate, long nid, long routableWayId) {
        return this.addToGraph(new BarrierPassThroughVertex(coordinate.x, coordinate.y, nid, routableWayId));
    }

    public TransitStopVertex transitStop(TransitStopVertexBuilder transitStopVertexBuilder) {
        return this.addToGraph(transitStopVertexBuilder.build());
    }

    public StationCentroidVertex stationCentroid(Station station) {
        return this.addToGraph(new StationCentroidVertex(station));
    }

    public VehicleParkingEntranceVertex vehicleParkingEntrance(VehicleParking vehicleParking) {
        return this.vehicleParkingEntrance(vehicleParking.getEntrances().get(0));
    }

    public VehicleParkingEntranceVertex vehicleParkingEntrance(VehicleParkingEntrance entrance) {
        return this.addToGraph(new VehicleParkingEntranceVertex(entrance));
    }

    public VehicleRentalPlaceVertex vehicleRentalPlace(VehicleRentalPlace station) {
        return this.addToGraph(new VehicleRentalPlaceVertex(station));
    }

    public TransitPathwayNodeVertex transitPathwayNode(PathwayNode node) {
        return this.addToGraph(new TransitPathwayNodeVertex(node));
    }

    public TransitEntranceVertex transitEntrance(Entrance entrance) {
        return this.addToGraph(new TransitEntranceVertex(entrance));
    }

    public OsmVertex levelledOsm(OsmNode node, String level) {
        return this.addToGraph(new OsmVertexOnLevel(node, level));
    }

    private <T extends Vertex> T addToGraph(T vertex) {
        this.graph.addVertex(vertex);
        return vertex;
    }
}

