/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import java.util.Collection;
import java.util.Objects;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingEntrance;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetVehicleParkingLink;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.model.vertex.VertexLabel;

public class VehicleParkingEntranceVertex
extends Vertex {
    private final VehicleParkingEntrance parkingEntrance;

    public VehicleParkingEntranceVertex(VehicleParkingEntrance parkingEntrance) {
        super(parkingEntrance.getCoordinate().longitude(), parkingEntrance.getCoordinate().latitude());
        this.parkingEntrance = parkingEntrance;
    }

    @Override
    public I18NString getName() {
        return Objects.requireNonNullElse(this.parkingEntrance.getName(), NO_NAME);
    }

    @Override
    public VertexLabel getLabel() {
        return VertexLabel.string("Vehicle parking " + String.valueOf(this.parkingEntrance.getEntranceId()));
    }

    public VehicleParkingEntrance getParkingEntrance() {
        return this.parkingEntrance;
    }

    public VehicleParking getVehicleParking() {
        return this.parkingEntrance.getVehicleParking();
    }

    public boolean isCarAccessible() {
        return this.parkingEntrance.isCarAccessible();
    }

    public boolean isWalkAccessible() {
        return this.parkingEntrance.isWalkAccessible();
    }

    public boolean isLinkedToGraph() {
        return this.hasLink(this.getIncoming()) || this.hasLink(this.getOutgoing());
    }

    private boolean hasLink(Collection<Edge> edges) {
        return edges.stream().anyMatch(StreetVehicleParkingLink.class::isInstance);
    }
}

