/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.PathwayEdge;
import org.opentripplanner.street.model.edge.StreetTransitEntityLink;
import org.opentripplanner.street.model.vertex.StationElementVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertexBuilder;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitStopVertex
extends StationElementVertex {
    private static final Logger LOG = LoggerFactory.getLogger(TransitStopVertex.class);
    private final Set<TransitMode> modes;
    private final Accessibility wheelchairAccessibility;
    private final RegularStop stop;
    private int streetToStopTime = 0;

    TransitStopVertex(RegularStop stop, Set<TransitMode> modes) {
        super(stop.getId(), stop.getLon(), stop.getLat(), stop.getName());
        this.stop = Objects.requireNonNull(stop);
        this.modes = modes != null ? modes : new HashSet();
        this.wheelchairAccessibility = stop.getWheelchairAccessibility();
    }

    public static TransitStopVertexBuilder of() {
        return new TransitStopVertexBuilder();
    }

    public Accessibility getWheelchairAccessibility() {
        return this.wheelchairAccessibility;
    }

    public boolean hasPathways() {
        for (Edge e : this.getOutgoing()) {
            if (!(e instanceof PathwayEdge)) continue;
            return true;
        }
        for (Edge e : this.getIncoming()) {
            if (!(e instanceof PathwayEdge)) continue;
            return true;
        }
        return false;
    }

    public int getStreetToStopTime() {
        return this.streetToStopTime;
    }

    public void setStreetToStopTime(int streetToStopTime) {
        this.streetToStopTime = streetToStopTime;
        LOG.debug("Stop {} access time from street level set to {}", (Object)this, (Object)streetToStopTime);
    }

    public Set<TransitMode> getModes() {
        return this.modes;
    }

    public void addMode(TransitMode mode) {
        this.modes.add(mode);
    }

    public RegularStop getStop() {
        return this.stop;
    }

    @Override
    public StationElement getStationElement() {
        return this.stop;
    }

    public boolean isConnectedToGraph() {
        return this.getDegreeOut() + this.getDegreeIn() > 0;
    }

    public boolean isLinkedToDrivableEdge() {
        return this.isLinkedToEdgeWhichAllows(TraverseMode.CAR);
    }

    public boolean isLinkedToWalkableEdge() {
        return this.isLinkedToEdgeWhichAllows(TraverseMode.WALK);
    }

    private boolean isLinkedToEdgeWhichAllows(TraverseMode traverseMode) {
        return this.getOutgoing().stream().anyMatch(edge -> {
            StreetTransitEntityLink link;
            return edge instanceof StreetTransitEntityLink && (link = (StreetTransitEntityLink)edge).getToVertex().getOutgoingStreetEdges().stream().anyMatch(se -> se.canTraverse(traverseMode));
        });
    }
}

