/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import java.util.concurrent.atomic.AtomicLong;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.TemporaryEdge;
import org.opentripplanner.street.model.vertex.StreetLocation;
import org.opentripplanner.street.model.vertex.TemporaryVertex;

public final class TemporaryStreetLocation
extends StreetLocation
implements TemporaryVertex {
    private static final AtomicLong idCounter = new AtomicLong(0L);

    public TemporaryStreetLocation(Coordinate nearestPoint, I18NString name) {
        super("TempVertex-" + idCounter.incrementAndGet(), nearestPoint, name);
    }

    @Override
    public void addOutgoing(Edge edge) {
        TemporaryStreetLocation.assertConnectToTemporaryEdge(edge);
        this.addRentalRestriction(edge.getToVertex().rentalRestrictions());
        super.addOutgoing(edge);
    }

    @Override
    public void addIncoming(Edge edge) {
        TemporaryStreetLocation.assertConnectToTemporaryEdge(edge);
        super.addIncoming(edge);
        this.addRentalRestriction(edge.getFromVertex().rentalRestrictions());
    }

    private static void assertConnectToTemporaryEdge(Edge edge) {
        if (!(edge instanceof TemporaryEdge)) {
            throw new UnsupportedOperationException("Can't add permanent edge to temporary vertex");
        }
    }
}

