/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.LocalizedString;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.transit.model.site.AreaStop;

public abstract class StreetVertex
extends Vertex {
    private static final Set<AreaStop> EMPTY_SET = Set.of();
    private Set<AreaStop> areaStops = EMPTY_SET;

    StreetVertex(double x, double y) {
        super(x, y);
    }

    public I18NString getIntersectionName() {
        HashSet<I18NString> uniqueNameSet = new HashSet<I18NString>();
        for (Edge e : this.getOutgoing()) {
            if (!(e instanceof StreetEdge)) continue;
            uniqueNameSet.add(e.getName());
        }
        ArrayList uniqueNames = new ArrayList(uniqueNameSet);
        if (uniqueNames.size() > 1) {
            return new LocalizedString("corner", (I18NString)uniqueNames.get(0), (I18NString)uniqueNames.get(1));
        }
        if (uniqueNames.size() == 1) {
            return (I18NString)uniqueNames.get(0);
        }
        return new LocalizedString("unnamedStreet");
    }

    public boolean isConnectedToWalkingEdge() {
        return this.getOutgoing().stream().anyMatch(edge -> edge instanceof StreetEdge && ((StreetEdge)edge).getPermission().allows(TraverseMode.WALK));
    }

    public boolean isConnectedToDriveableEdge() {
        return this.getOutgoing().stream().anyMatch(edge -> edge instanceof StreetEdge && ((StreetEdge)edge).getPermission().allows(TraverseMode.CAR));
    }

    public boolean isEligibleForCarPickupDropoff() {
        return this.isConnectedToDriveableEdge() && this.isConnectedToWalkingEdge();
    }

    @Override
    public Set<AreaStop> areaStops() {
        return this.areaStops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAreaStops(Collection<AreaStop> toBeAdded) {
        Objects.requireNonNull(toBeAdded);
        StreetVertex streetVertex = this;
        synchronized (streetVertex) {
            this.areaStops = this.areaStops == EMPTY_SET ? Set.copyOf(toBeAdded) : Stream.concat(this.areaStops.stream(), toBeAdded.stream()).collect(Collectors.toUnmodifiableSet());
        }
    }
}

