/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.VertexLabel;

public class StreetLocation
extends StreetVertex {
    private final I18NString name;
    private boolean wheelchairAccessible;
    private final VertexLabel label;

    public StreetLocation(String id, Coordinate nearestPoint, I18NString name) {
        super(nearestPoint.x, nearestPoint.y);
        this.label = VertexLabel.string(id);
        this.name = name;
    }

    public boolean isWheelchairAccessible() {
        return this.wheelchairAccessible;
    }

    public void setWheelchairAccessible(boolean wheelchairAccessible) {
        this.wheelchairAccessible = wheelchairAccessible;
    }

    @Override
    public VertexLabel getLabel() {
        return this.label;
    }

    @Override
    public I18NString getIntersectionName() {
        return this.getName();
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    public int hashCode() {
        return this.getCoordinate().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof StreetLocation) {
            StreetLocation other = (StreetLocation)o;
            return other.getCoordinate().equals((Object)this.getCoordinate());
        }
        return false;
    }
}

