/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.street.model.vertex.LabelledIntersectionVertex;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class OsmBoardingLocationVertex
extends LabelledIntersectionVertex {
    public final Set<String> references;
    private final I18NString name;

    public OsmBoardingLocationVertex(String label, double x, double y, @Nullable I18NString name, Collection<String> references) {
        super(label, x, y, false, false);
        this.references = Set.copyOf(references);
        this.name = Objects.requireNonNullElse(name, NO_NAME);
    }

    @Override
    public String toString() {
        return ToStringBuilder.of(this.getClass()).addCol("references", this.references).toString();
    }

    public boolean isConnectedToStreetNetwork() {
        return this.getOutgoing().size() + this.getIncoming().size() > 0;
    }

    @Override
    public I18NString getName() {
        return this.name;
    }
}

