/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.utils.lang.BitSetUtils;

public abstract class IntersectionVertex
extends StreetVertex {
    private static final int HIGHWAY_TRAFFIC_LIGHT_INDEX = 0;
    private static final int CROSSING_TRAFFIC_LIGHT_INDEX = 1;
    private final short flags;

    protected IntersectionVertex(double x, double y, boolean hasHighwayTrafficLight, boolean hasCrossingTrafficLight) {
        super(x, y);
        this.flags = IntersectionVertex.initFlags(hasHighwayTrafficLight, hasCrossingTrafficLight);
    }

    protected IntersectionVertex(double x, double y) {
        this(x, y, false, false);
    }

    public boolean hasCyclingTrafficLight() {
        return !this.hasNoTrafficLight();
    }

    public boolean hasWalkingTrafficLight() {
        return BitSetUtils.get((short)this.flags, (int)1);
    }

    public boolean hasDrivingTrafficLight() {
        return BitSetUtils.get((short)this.flags, (int)0);
    }

    public boolean inferredFreeFlowing() {
        return this.getDegreeIn() == 1 && this.getDegreeOut() == 1 && this.hasNoTrafficLight();
    }

    private boolean hasNoTrafficLight() {
        return this.flags == 0;
    }

    private static short initFlags(boolean highwayTrafficLight, boolean crossingTrafficLight) {
        short flags = 0;
        flags = BitSetUtils.set((short)flags, (int)0, (boolean)highwayTrafficLight);
        flags = BitSetUtils.set((short)flags, (int)1, (boolean)crossingTrafficLight);
        return flags;
    }
}

