/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import java.util.Collection;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.OsmVertex;
import org.opentripplanner.transit.model.basic.Accessibility;

public class BarrierVertex
extends OsmVertex {
    public static final StreetTraversalPermission defaultBarrierPermissions = StreetTraversalPermission.ALL;
    private StreetTraversalPermission barrierPermissions = defaultBarrierPermissions;
    protected Accessibility wheelchairAccessibility;

    public BarrierVertex(double x, double y, long nodeId, Accessibility wheelchairAccessibility) {
        super(x, y, nodeId);
        this.wheelchairAccessibility = wheelchairAccessibility;
    }

    public StreetTraversalPermission getBarrierPermissions() {
        return this.barrierPermissions;
    }

    public void setBarrierPermissions(StreetTraversalPermission barrierPermissions) {
        this.barrierPermissions = barrierPermissions;
    }

    public Accessibility wheelchairAccessibility() {
        return this.wheelchairAccessibility;
    }

    public void setWheelchairAccessibility(Accessibility wheelchairAccessibility) {
        this.wheelchairAccessibility = wheelchairAccessibility;
    }

    public void makeBarrierAtEndReachable() {
        int edgeCount = this.getDegreeOut() + this.getDegreeIn();
        boolean needsFix = false;
        if (edgeCount == 1) {
            needsFix = true;
        } else if (edgeCount == 2) {
            Collection<Edge> out = this.getOutgoing();
            Collection<Edge> in = this.getIncoming();
            if (out.isEmpty() || in.isEmpty() || out.iterator().next().getToVertex() == in.iterator().next().getFromVertex()) {
                needsFix = true;
            }
        }
        if (needsFix) {
            this.barrierPermissions = StreetTraversalPermission.ALL;
        }
    }
}

