/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.time.Duration;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.BikePreferences;
import org.opentripplanner.routing.api.request.preference.CarPreferences;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleParkingPreferences;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class VehicleParkingEdge
extends Edge {
    private final VehicleParking vehicleParking;

    private VehicleParkingEdge(VehicleParkingEntranceVertex vehicleParkingEntranceVertex) {
        this(vehicleParkingEntranceVertex, vehicleParkingEntranceVertex);
    }

    private VehicleParkingEdge(VehicleParkingEntranceVertex fromVehicleParkingEntranceVertex, VehicleParkingEntranceVertex toVehicleParkingEntranceVertex) {
        super(fromVehicleParkingEntranceVertex, toVehicleParkingEntranceVertex);
        this.vehicleParking = fromVehicleParkingEntranceVertex.getVehicleParking();
    }

    public static VehicleParkingEdge createVehicleParkingEdge(VehicleParkingEntranceVertex vehicleParkingEntranceVertex) {
        return VehicleParkingEdge.connectToGraph(new VehicleParkingEdge(vehicleParkingEntranceVertex));
    }

    public static VehicleParkingEdge createVehicleParkingEdge(VehicleParkingEntranceVertex fromVehicleParkingEntranceVertex, VehicleParkingEntranceVertex toVehicleParkingEntranceVertex) {
        return VehicleParkingEdge.connectToGraph(new VehicleParkingEdge(fromVehicleParkingEntranceVertex, toVehicleParkingEntranceVertex));
    }

    public VehicleParking getVehicleParking() {
        return this.vehicleParking;
    }

    public boolean equals(Object o) {
        if (o instanceof VehicleParkingEdge) {
            VehicleParkingEdge other = (VehicleParkingEdge)o;
            return other.getFromVertex().equals(this.fromv) && other.getToVertex().equals(this.tov);
        }
        return false;
    }

    public State[] traverse(State s0) {
        if (!s0.getRequest().mode().includesParking()) {
            return State.empty();
        }
        if (s0.getRequest().arriveBy()) {
            return this.traverseUnPark(s0);
        }
        return this.traversePark(s0);
    }

    @Override
    public I18NString getName() {
        return this.getToVertex().getName();
    }

    protected State[] traverseUnPark(State s0) {
        if (s0.currentMode() != TraverseMode.WALK || !s0.isVehicleParked()) {
            return State.empty();
        }
        StreetMode streetMode = s0.getRequest().mode();
        if (streetMode.includesBiking()) {
            BikePreferences bike = s0.getPreferences().bike();
            return this.traverseUnPark(s0, bike.parking().cost(), bike.parking().time(), TraverseMode.BICYCLE);
        }
        if (streetMode.includesDriving()) {
            CarPreferences car = s0.getPreferences().car();
            return this.traverseUnPark(s0, car.parking().cost(), car.parking().time(), TraverseMode.CAR);
        }
        return State.empty();
    }

    private State[] traverseUnPark(State s0, Cost parkingCost, Duration parkingTime, TraverseMode mode) {
        StreetSearchRequest request = s0.getRequest();
        if (!this.vehicleParking.hasSpacesAvailable(mode, request.wheelchair())) {
            return State.empty();
        }
        StateEditor s0e = s0.edit(this);
        s0e.incrementWeight(parkingCost.toSeconds());
        s0e.incrementTimeInMilliseconds(parkingTime.toMillis());
        s0e.setVehicleParked(false, mode);
        VehicleParkingPreferences parkingPreferences = s0.getRequest().preferences().parking(s0.currentMode());
        this.addUnpreferredTagCost(parkingPreferences, s0e);
        return s0e.makeStateArray();
    }

    private State[] traversePark(State s0) {
        StreetMode streetMode = s0.getRequest().mode();
        RoutingPreferences preferences = s0.getPreferences();
        if (!streetMode.includesWalking() || s0.isVehicleParked()) {
            return State.empty();
        }
        if (streetMode.includesBiking()) {
            if (s0.isRentingVehicle()) {
                return State.empty();
            }
            return this.traversePark(s0, preferences.bike().parking().cost(), preferences.bike().parking().time());
        }
        if (streetMode.includesDriving()) {
            return this.traversePark(s0, preferences.car().parking().cost(), preferences.car().parking().time());
        }
        return State.empty();
    }

    private State[] traversePark(State s0, Cost parkingCost, Duration parkingTime) {
        if (!this.vehicleParking.hasSpacesAvailable(s0.currentMode(), s0.getRequest().wheelchair())) {
            return State.empty();
        }
        StateEditor s0e = s0.edit(this);
        s0e.incrementWeight(parkingCost.toSeconds());
        s0e.incrementTimeInMilliseconds(parkingTime.toMillis());
        s0e.setVehicleParked(true, TraverseMode.WALK);
        VehicleParkingPreferences parkingPreferences = s0.getRequest().preferences().parking(s0.currentMode());
        this.addUnpreferredTagCost(parkingPreferences, s0e);
        return s0e.makeStateArray();
    }

    private void addUnpreferredTagCost(VehicleParkingPreferences preferences, StateEditor s0e) {
        if (!preferences.preferred().matches(this.vehicleParking)) {
            s0e.incrementWeight(preferences.unpreferredVehicleParkingTagCost().toSeconds());
        }
    }
}

