/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.TemporaryEdge;
import org.opentripplanner.street.model.edge.TemporaryPartialStreetEdgeBuilder;

public final class TemporaryPartialStreetEdge
extends StreetEdge
implements TemporaryEdge {
    private final StreetEdge parentEdge;
    private final LineString geometry;

    TemporaryPartialStreetEdge(TemporaryPartialStreetEdgeBuilder builder) {
        super(builder);
        builder.fromVertex().addRentalRestriction(builder.parentEdge().getFromVertex().rentalRestrictions());
        builder.toVertex().addRentalRestriction(builder.parentEdge().getToVertex().rentalRestrictions());
        this.parentEdge = builder.parentEdge();
        this.geometry = super.getGeometry();
    }

    @Override
    public boolean isEquivalentTo(Edge e) {
        return e == this || e == this.parentEdge;
    }

    public boolean isTrivial() {
        Coordinate fromCoord = this.getFromVertex().getCoordinate();
        Coordinate toCoord = this.getToVertex().getCoordinate();
        return fromCoord.equals((Object)toCoord);
    }

    public StreetEdge getParentEdge() {
        return this.parentEdge;
    }

    @Override
    public String toString() {
        return this.buildToString(this.getDefaultName(), b -> b.append(", length=").append(this.getCarSpeed()).append(", parentEdge=").append(this.parentEdge));
    }

    @Override
    public boolean isRoundabout() {
        return this.parentEdge.isRoundabout();
    }

    @Override
    public LineString getGeometry() {
        return this.geometry;
    }

    @Override
    public int getInAngle() {
        return this.parentEdge.getInAngle();
    }

    @Override
    public int getOutAngle() {
        return this.parentEdge.getOutAngle();
    }
}

