/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.request.preference.VehicleParkingPreferences;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingEntrance;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class StreetVehicleParkingLink
extends Edge {
    private final VehicleParkingEntranceVertex vehicleParkingEntranceVertex;

    private StreetVehicleParkingLink(StreetVertex fromv, VehicleParkingEntranceVertex tov) {
        super(fromv, tov);
        this.vehicleParkingEntranceVertex = tov;
    }

    private StreetVehicleParkingLink(VehicleParkingEntranceVertex fromv, StreetVertex tov) {
        super(fromv, tov);
        this.vehicleParkingEntranceVertex = fromv;
    }

    public static StreetVehicleParkingLink createStreetVehicleParkingLink(StreetVertex fromv, VehicleParkingEntranceVertex tov) {
        return StreetVehicleParkingLink.connectToGraph(new StreetVehicleParkingLink(fromv, tov));
    }

    public static StreetVehicleParkingLink createStreetVehicleParkingLink(VehicleParkingEntranceVertex fromv, StreetVertex tov) {
        return StreetVehicleParkingLink.connectToGraph(new StreetVehicleParkingLink(fromv, tov));
    }

    public State[] traverse(State s0) {
        if (s0.getBackEdge() instanceof StreetVehicleParkingLink) {
            return State.empty();
        }
        VehicleParkingEntrance entrance = this.vehicleParkingEntranceVertex.getParkingEntrance();
        if (s0.currentMode() == TraverseMode.CAR ? !entrance.isCarAccessible() : !entrance.isWalkAccessible()) {
            return State.empty();
        }
        VehicleParking vehicleParking = this.vehicleParkingEntranceVertex.getVehicleParking();
        VehicleParkingPreferences parkingPreferences = s0.getRequest().preferences().parking(s0.currentMode());
        if (this.traversalBanned(parkingPreferences, vehicleParking)) {
            return State.empty();
        }
        StateEditor s1 = s0.edit(this);
        s1.incrementWeight(1.0);
        s1.setBackMode(null);
        return s1.makeStateArray();
    }

    private boolean traversalBanned(VehicleParkingPreferences parkingPreferences, VehicleParking vehicleParking) {
        return !parkingPreferences.filter().matches(vehicleParking);
    }

    @Override
    public I18NString getName() {
        return this.vehicleParkingEntranceVertex.getName();
    }

    @Override
    public LineString getGeometry() {
        return GeometryUtils.makeLineString(this.fromv.getCoordinate(), this.tov.getCoordinate());
    }
}

