/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.opentripplanner.street.model.edge.StreetTransitEntityLink;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.TransitEntranceVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.site.Entrance;

public class StreetTransitEntranceLink
extends StreetTransitEntityLink<TransitEntranceVertex> {
    private final boolean isEntrance;

    private StreetTransitEntranceLink(StreetVertex fromv, TransitEntranceVertex tov) {
        super(fromv, tov, tov.getWheelchairAccessibility());
        this.isEntrance = true;
    }

    private StreetTransitEntranceLink(TransitEntranceVertex fromv, StreetVertex tov) {
        super(fromv, tov, fromv.getWheelchairAccessibility());
        this.isEntrance = false;
    }

    public static StreetTransitEntranceLink createStreetTransitEntranceLink(StreetVertex fromv, TransitEntranceVertex tov) {
        return StreetTransitEntranceLink.connectToGraph(new StreetTransitEntranceLink(fromv, tov));
    }

    public static StreetTransitEntranceLink createStreetTransitEntranceLink(TransitEntranceVertex fromv, StreetVertex tov) {
        return StreetTransitEntranceLink.connectToGraph(new StreetTransitEntranceLink(fromv, tov));
    }

    public boolean isEntrance() {
        return this.isEntrance;
    }

    public boolean isExit() {
        return !this.isEntrance;
    }

    public Entrance entrance() {
        Vertex vertex = this.getToVertex();
        if (vertex instanceof TransitEntranceVertex) {
            TransitEntranceVertex tev = (TransitEntranceVertex)vertex;
            return tev.getEntrance();
        }
        vertex = this.getFromVertex();
        if (vertex instanceof TransitEntranceVertex) {
            TransitEntranceVertex tev = (TransitEntranceVertex)vertex;
            return tev.getEntrance();
        }
        throw new IllegalStateException("%s doesn't link to an entrance.".formatted(this));
    }

    @Override
    protected int getStreetToStopTime() {
        return 0;
    }
}

