/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.preference.VehicleRentalPreferences;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.street.model.edge.CarPickupableEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.transit.model.basic.Accessibility;

public abstract class StreetTransitEntityLink<T extends Vertex>
extends Edge
implements CarPickupableEdge {
    static final int STEL_TRAVERSE_COST = 1;
    private final T transitEntityVertex;
    private final Accessibility wheelchairAccessibility;

    protected StreetTransitEntityLink(StreetVertex fromv, T tov, Accessibility wheelchairAccessibility) {
        super(fromv, (Vertex)tov);
        this.transitEntityVertex = tov;
        this.wheelchairAccessibility = wheelchairAccessibility;
    }

    protected StreetTransitEntityLink(T fromv, StreetVertex tov, Accessibility wheelchairAccessibility) {
        super((Vertex)fromv, tov);
        this.transitEntityVertex = fromv;
        this.wheelchairAccessibility = wheelchairAccessibility;
    }

    public State[] traverse(State s0) {
        Edge edge = s0.backEdge;
        if (edge instanceof StreetTransitEntityLink) {
            StreetTransitEntityLink link = (StreetTransitEntityLink)edge;
            if (link.transitEntityVertex == this.transitEntityVertex) {
                return State.empty();
            }
        }
        RoutingPreferences pref = s0.getPreferences();
        StateEditor s1 = s0.edit(this);
        if (s0.getRequest().wheelchair()) {
            WheelchairPreferences accessibility = pref.wheelchair();
            if (accessibility.stop().onlyConsiderAccessible() && this.wheelchairAccessibility != Accessibility.POSSIBLE) {
                return State.empty();
            }
            if (this.wheelchairAccessibility == Accessibility.NO_INFORMATION) {
                s1.incrementWeight(accessibility.stop().unknownCost());
            } else if (this.wheelchairAccessibility == Accessibility.NOT_POSSIBLE) {
                s1.incrementWeight(accessibility.stop().inaccessibleCost());
            }
        }
        return switch (s0.currentMode()) {
            default -> throw new MatchException(null, null);
            case TraverseMode.BICYCLE, TraverseMode.SCOOTER -> {
                if (s0.getRequest().mode().includesParking() && !s0.isVehicleParked()) {
                    yield State.empty();
                }
                if (!(!s0.isRentingVehicleFromStation() || s0.mayKeepRentedVehicleAtDestination() && s0.getRequest().preferences().rental(s0.getRequest().mode()).allowArrivingInRentedVehicleAtDestination())) {
                    yield State.empty();
                }
                yield this.buildState(s0, s1, pref);
            }
            case TraverseMode.CAR -> {
                if (s0.getRequest().mode().includesParking() && !s0.isVehicleParked()) {
                    yield State.empty();
                }
                if (s0.getCarPickupState() != null) {
                    if (this.canDropOffAfterDriving(s0) && this.isLeavingStreetNetwork(s0.getRequest().arriveBy())) {
                        this.dropOffAfterDriving(s0, s1);
                    } else {
                        yield State.empty();
                    }
                }
                if (s0.isRentingVehicleFromStation()) {
                    yield State.empty();
                }
                yield this.buildState(s0, s1, pref);
            }
            case TraverseMode.WALK -> this.buildState(s0, s1, pref);
            case TraverseMode.FLEX -> State.empty();
        };
    }

    private State[] buildState(State s0, StateEditor s1, RoutingPreferences pref) {
        VehicleRentalPreferences rentalPreferences;
        if (s0.isRentingVehicleFromStation() && s0.mayKeepRentedVehicleAtDestination() && (rentalPreferences = s0.getRequest().preferences().rental(s0.getRequest().mode())).allowArrivingInRentedVehicleAtDestination()) {
            s1.incrementWeight(rentalPreferences.arrivingInRentalVehicleAtDestinationCost().toSeconds());
        }
        s1.setBackMode(null);
        int streetToStopTime = this.getStreetToStopTime();
        s1.incrementTimeInSeconds(streetToStopTime);
        s1.incrementWeight(1 + streetToStopTime);
        return s1.makeStateArray();
    }

    @Override
    public I18NString getName() {
        return ((Vertex)this.transitEntityVertex).getName();
    }

    @Override
    public LineString getGeometry() {
        Coordinate[] coordinates = new Coordinate[]{this.fromv.getCoordinate(), this.tov.getCoordinate()};
        return GeometryUtils.getGeometryFactory().createLineString(coordinates);
    }

    protected abstract int getStreetToStopTime();

    protected T getTransitEntityVertex() {
        return this.transitEntityVertex;
    }

    boolean isLeavingStreetNetwork(boolean arriveBy) {
        return (arriveBy ? this.fromv : this.tov) == this.getTransitEntityVertex();
    }
}

